/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcService;
import house.intelli.core.util.ReflectionUtil;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class AbstractRpcService<REQ extends Request<RES>, RES extends Response>
implements RpcService<REQ, RES>,
Cloneable {
    private Class<REQ> requestType;
    private Class<RES> responseType;
    private RpcContext rpcContext;

    @Override
    public Class<REQ> getRequestType() {
        if (this.requestType == null) {
            Class rq;
            Class rs;
            Type[] actualTypeArguments = ReflectionUtil.resolveActualTypeArguments(AbstractRpcService.class, this);
            if (!(actualTypeArguments[0] instanceof Class)) {
                throw new IllegalStateException("Implementation error in class " + this.getClass().getName() + ": Generic type REQ is still undefined, i.e. not a concrete class, but: " + actualTypeArguments[0]);
            }
            if (!(actualTypeArguments[1] instanceof Class)) {
                throw new IllegalStateException("Implementation error in class " + this.getClass().getName() + ": Generic type REQ is still undefined, i.e. not a concrete class, but: " + actualTypeArguments[0]);
            }
            this.responseType = rs = (Class)actualTypeArguments[1];
            this.requestType = rq = (Class)actualTypeArguments[0];
        }
        return this.requestType;
    }

    @Override
    public Class<RES> getResponseType() {
        if (this.responseType == null) {
            this.getRequestType();
            Objects.requireNonNull(this.responseType, "responseType");
        }
        return this.responseType;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Override
    public void setRpcContext(RpcContext rpcContext) {
        if (this.rpcContext != null) {
            throw new IllegalStateException("this.rpcContext already assigned!");
        }
        this.rpcContext = rpcContext;
    }

    @Override
    public RpcService<REQ, RES> clone() {
        try {
            return (RpcService)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

