/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.util.AssertUtil;
import house.intelli.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlJavaTypeAdapter(type=HostId.class, value=HostIdXmlAdapter.class)
public class HostId
implements Comparable<HostId> {
    private static final Logger logger = LoggerFactory.getLogger(HostId.class);
    public static final Pattern HOSTID_PATTERN = Pattern.compile("[A-Za-z0-9_\\-\\.]*");
    public static final HostId SERVER = new HostId("server");
    private static volatile HostId localHostId;
    private final String id;

    public static HostId getLocalHostId() throws IllegalStateException {
        if (localHostId == null) {
            localHostId = HostId._getLocalHostId();
        }
        return localHostId;
    }

    protected static HostId _getLocalHostId() throws IllegalStateException {
        HostId hostId;
        BufferedReader r2;
        Throwable throwable;
        InputStream in;
        String envName = "HOSTNAME";
        String hostName = StringUtil.trim(System.getenv("HOSTNAME"));
        if (!StringUtil.isEmpty(hostName)) {
            try {
                HostId hostId2 = new HostId(hostName);
                return hostId2;
            }
            catch (Exception x) {
                throw new IllegalStateException(String.format("Environment variable '%s' contains illegal value '%s': %s", "HOSTNAME", hostName, x), x);
            }
        }
        logger.warn("Environment variable '{}' is missing or empty.", (Object)"HOSTNAME");
        String program = "hostname";
        try {
            Process process = Runtime.getRuntime().exec("hostname");
            process.waitFor(10L, TimeUnit.SECONDS);
            in = process.getInputStream();
            throwable = null;
            try {
                r2 = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                hostName = StringUtil.trim(r2.readLine());
            }
            catch (Throwable r2) {
                throwable = r2;
                throw r2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable r2) {
                            throwable.addSuppressed(r2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            if (!StringUtil.isEmpty(hostName)) {
                try {
                    hostId = new HostId(hostName);
                    return hostId;
                }
                catch (Exception x) {
                    logger.warn("Program '{}' returned illegal value '{}': {}", new Object[]{"hostname", hostName, x});
                }
            } else {
                logger.warn("Program '{}' returned an empty result.", (Object)"hostname");
            }
        }
        catch (Exception e) {
            logger.warn("Calling program 'hostname' failed: " + e, (Throwable)e);
        }
        File file = new File("/etc/hostname");
        if (file.exists()) {
            try {
                in = new FileInputStream(file);
                throwable = null;
                try {
                    r2 = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    hostName = StringUtil.trim(r2.readLine());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Reading file '" + file + "' failed: " + e, (Throwable)e);
            }
            if (!StringUtil.isEmpty(hostName)) {
                try {
                    hostId = new HostId(hostName);
                    return hostId;
                }
                catch (Exception x) {
                    logger.warn("File '{}' contained illegal value '{}': {}", new Object[]{file, hostName, x});
                }
            } else {
                logger.warn("File '{}' is empty or contains an empty first line.", (Object)file);
            }
        } else {
            logger.warn("File '" + file + "' does not exist!");
        }
        throw new IllegalStateException(String.format("Could not determine local hostname! Tried environment variable '%s', program '%s' and file '%s'!", "HOSTNAME", "hostname", file));
    }

    public HostId(String id) {
        this.id = AssertUtil.assertNotEmpty(id, "id");
        if (!HOSTID_PATTERN.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("HostId '%s' is not valid!", id));
        }
    }

    public String toString() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostId other = (HostId)obj;
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(HostId other) {
        Objects.requireNonNull(other, "other");
        return this.id.compareTo(other.id);
    }

    public static class HostIdXmlAdapter
    extends XmlAdapter<String, HostId> {
        public HostId unmarshal(String v) throws Exception {
            return new HostId(v);
        }

        public String marshal(HostId v) throws Exception {
            return v.toString();
        }
    }
}

