/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.rpc.JaxbRpcClientTransport;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;

public class HttpRpcClientTransport
extends JaxbRpcClientTransport {
    private URL serverUrl;
    private HttpURLConnection connection;
    private boolean requestSent;

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(URL serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Override
    protected OutputStream createRequestOutputStream() throws IOException {
        this.closeConnection();
        OutputStream out = this.getConnection().getOutputStream();
        return new FilterOutputStream(out){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    HttpRpcClientTransport.this.requestSent = true;
                }
            }
        };
    }

    @Override
    protected InputStream createResponseInputStream() throws IOException {
        if (!this.requestSent) {
            throw new IllegalStateException("request not yet sent!");
        }
        InputStream in = this.getConnection().getInputStream();
        return new FilterInputStream(in){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    HttpRpcClientTransport.this.closeConnection();
                }
            }
        };
    }

    protected HttpURLConnection getConnection() throws IOException {
        if (this.connection == null) {
            this.requestSent = false;
            this.connection = (HttpURLConnection)Objects.requireNonNull(this.getServerUrl(), "serverUrl").openConnection();
            this.connection.setConnectTimeout(15000);
            this.connection.setReadTimeout(50000);
            this.connection.setRequestMethod("POST");
            this.connection.setRequestProperty("Content-Type", "application/octet-stream");
            this.connection.setRequestProperty("Connection", "keep-alive");
            this.connection.setUseCaches(false);
            this.connection.setDoOutput(true);
            this.connection.setAllowUserInteraction(false);
            this.connection.connect();
        }
        return this.connection;
    }

    protected void closeConnection() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Override
    public void close() {
        this.closeConnection();
        super.close();
    }
}

