/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InverseRequestRegistry {
    private static final Logger logger = LoggerFactory.getLogger(InverseRequestRegistry.class);
    private static final long EVICT_PERIOD = 3600000L;
    private final RpcContext rpcContext;
    private final Object mutex = new Object();
    private final Map<HostId, Map<Uid, Request<?>>> serverHostId2RequestId2Request = new HashMap();
    private final Map<Uid, EvictDescriptor> requestId2EvictDescriptor = new HashMap<Uid, EvictDescriptor>();
    private final Timer evictTimer;
    private final TimerTask evictTimerTask;

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    protected InverseRequestRegistry(RpcContext rpcContext) {
        this.rpcContext = Objects.requireNonNull(rpcContext, "rpcContext");
        this.evictTimer = new Timer(String.format("RpcServiceExecutor[%s].evictTimer", rpcContext.getLocalHostId()), true);
        this.evictTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    InverseRequestRegistry.this.evict();
                }
                catch (Throwable x) {
                    logger.error("evictTimerTask.run: " + x + ' ', x);
                }
            }
        };
        this.evictTimer.schedule(this.evictTimerTask, 3600000L, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequest(Request<?> request) {
        Objects.requireNonNull(request, "request");
        HostId serverHostId = Objects.requireNonNull(request.getServerHostId(), "request.serverHostId");
        Uid requestId = Objects.requireNonNull(request.getRequestId(), "request.requestId");
        Object object = this.mutex;
        synchronized (object) {
            Request<?> old;
            Map<Uid, Request<?>> requestId2Request = this.serverHostId2RequestId2Request.get(serverHostId);
            if (requestId2Request == null) {
                requestId2Request = new HashMap();
                this.serverHostId2RequestId2Request.put(serverHostId, requestId2Request);
            }
            if ((old = requestId2Request.put(requestId, request)) != null && old != request) {
                throw new IllegalArgumentException("There was already another request with the same requestId! WTF?! requestId=" + requestId);
            }
            this.requestId2EvictDescriptor.put(requestId, new EvictDescriptor(request));
            this.mutex.notifyAll();
        }
    }

    public List<Request<?>> pollRequests(HostId serverHostId, long timeout) {
        Objects.requireNonNull(serverHostId, "serverHostId");
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        long startTimestamp = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                long elapsedTime;
                long remainingTime;
                do {
                    Map<Uid, Request<?>> requestId2Request;
                    if ((requestId2Request = this.serverHostId2RequestId2Request.remove(serverHostId)) != null && !requestId2Request.isEmpty()) {
                        ArrayList result = new ArrayList(requestId2Request.values());
                        requestId2Request.keySet().forEach(requestId -> this.requestId2EvictDescriptor.remove(requestId));
                        return Collections.unmodifiableList(result);
                    }
                    elapsedTime = System.currentTimeMillis() - startTimestamp;
                    if (elapsedTime <= timeout) continue;
                    return Collections.emptyList();
                } while ((remainingTime = timeout - elapsedTime) <= 0L);
                try {
                    this.mutex.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    logger.info("pollRequests: " + e, (Throwable)e);
                    return Collections.emptyList();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        long now = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            Iterator<EvictDescriptor> it = this.requestId2EvictDescriptor.values().iterator();
            while (it.hasNext()) {
                EvictDescriptor evictDescriptor = it.next();
                if (evictDescriptor.timeoutElapsed >= now) continue;
                Map<Uid, Request<?>> requestId2Request = this.serverHostId2RequestId2Request.get(evictDescriptor.serverHostId);
                if (requestId2Request != null) {
                    requestId2Request.remove(evictDescriptor.requestId);
                    if (requestId2Request.isEmpty()) {
                        this.serverHostId2RequestId2Request.remove(evictDescriptor.serverHostId);
                    }
                }
                it.remove();
            }
        }
    }

    private static class EvictDescriptor {
        public final HostId serverHostId;
        public final Uid requestId;
        public final long created = System.currentTimeMillis();
        public final long timeout;
        public final long timeoutElapsed;

        public EvictDescriptor(Request<?> request) {
            Objects.requireNonNull(request, "request");
            this.serverHostId = Objects.requireNonNull(request.getServerHostId(), "request.serverHostId");
            this.requestId = Objects.requireNonNull(request.getRequestId(), "request.requestId");
            this.timeout = request.getTimeout() == 0L ? 600000L : request.getTimeout();
            this.timeoutElapsed = this.created + this.timeout;
        }
    }
}

