/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.jaxb.IntelliHouseJaxbContext;
import house.intelli.core.rpc.AbstractRpcClientTransport;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class JaxbRpcClientTransport
extends AbstractRpcClientTransport {
    private JAXBContext jaxbContext;

    protected abstract OutputStream createRequestOutputStream() throws IOException;

    protected abstract InputStream createResponseInputStream() throws IOException;

    @Override
    public void sendRequest(Request<?> request) throws IOException {
        Objects.requireNonNull(request, "request");
        JAXBContext jaxbContext = this.getJaxbContext();
        try (OutputStream outputStream = this.createRequestOutputStream();){
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal(request, outputStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Response receiveResponse() throws IOException {
        Object unmarshalled;
        JAXBContext jaxbContext = this.getJaxbContext();
        try (InputStream inputStream = this.createResponseInputStream();){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshalled = unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
        return (Response)unmarshalled;
    }

    protected JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            this.jaxbContext = IntelliHouseJaxbContext.getJaxbContext();
        }
        return this.jaxbContext;
    }
}

