/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.jaxb.IntelliHouseJaxbContext;
import house.intelli.core.rpc.AbstractRpcServerTransport;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class JaxbRpcServerTransport
extends AbstractRpcServerTransport {
    private JAXBContext jaxbContext;

    protected abstract InputStream createRequestInputStream() throws IOException;

    protected abstract OutputStream createResponseOutputStream() throws IOException;

    @Override
    public Request<?> receiveRequest() throws IOException {
        Object unmarshalled;
        JAXBContext jaxbContext = this.getJaxbContext();
        try (InputStream inputStream = this.createRequestInputStream();){
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshalled = unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException x) {
            throw new IOException(x);
        }
        return (Request)unmarshalled;
    }

    @Override
    public void sendResponse(Response response) throws IOException {
        JAXBContext jaxbContext = this.getJaxbContext();
        try (OutputStream outputStream = this.createResponseOutputStream();){
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)response, outputStream);
        }
        catch (JAXBException x) {
            throw new IOException(x);
        }
    }

    protected JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            this.jaxbContext = IntelliHouseJaxbContext.getJaxbContext();
        }
        return this.jaxbContext;
    }
}

