/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.rpc.Error;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.PollInverseRequestsRequest;
import house.intelli.core.rpc.PollInverseRequestsResponse;
import house.intelli.core.rpc.PutInverseResponseRequest;
import house.intelli.core.rpc.RemoteExceptionUtil;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollInverseRequestsThread
extends Thread {
    private static final long SLEEP_ON_ERROR_MIN = 250L;
    private static final long SLEEP_ON_ERROR_MAX = 10000L;
    private static final Logger logger = LoggerFactory.getLogger(PollInverseRequestsThread.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final RpcContext rpcContext;
    private volatile boolean interrupted;

    public PollInverseRequestsThread(RpcContext rpcContext) {
        this.rpcContext = Objects.requireNonNull(rpcContext, "rpcContext");
        this.setName(this.getClass().getSimpleName() + '-' + rpcContext.getLocalHostId());
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Override
    public void run() {
        long sleepOnError = 250L;
        while (!this.isInterrupted() && this.rpcContext.getRpcClientTransportProvider() == null) {
            logger.info("run: rpcContext.rpcClientTransportProvider not yet assigned! Going to retry later.");
            try {
                PollInverseRequestsThread.sleep(sleepOnError);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sleepOnError = Math.min(sleepOnError * 2L, 10000L);
        }
        sleepOnError = 250L;
        while (!this.isInterrupted()) {
            try {
                try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
                    PollInverseRequestsRequest request = new PollInverseRequestsRequest();
                    request.setServerHostId(HostId.SERVER);
                    PollInverseRequestsResponse response = (PollInverseRequestsResponse)rpcClient.invoke(request);
                    for (Request<?> inverseRequest : response.getInverseRequests()) {
                        this.putInverseRequest(inverseRequest);
                    }
                }
                sleepOnError = 250L;
            }
            catch (Throwable x) {
                logger.error("run:" + x + ' ', x);
                try {
                    PollInverseRequestsThread.sleep(sleepOnError);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sleepOnError = Math.min(sleepOnError * 2L, 10000L);
            }
        }
    }

    protected void putInverseRequest(final Request<?> inverseRequest) {
        Objects.requireNonNull(inverseRequest, "inverseRequest");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!PollInverseRequestsThread.this.rpcContext.isServerLocal(inverseRequest)) {
                        throw new UnsupportedOperationException("Inverse-channel does not support forwarding!");
                    }
                    Response inverseResponse = PollInverseRequestsThread.this.processLocally(inverseRequest);
                    PollInverseRequestsThread.this.putInverseResponse(inverseResponse);
                }
                catch (Throwable x) {
                    Error error = RemoteExceptionUtil.createError(x);
                    ErrorResponse errorResponse = new ErrorResponse(error);
                    errorResponse.copyRequestCoordinates(inverseRequest);
                    PollInverseRequestsThread.this.putInverseResponse(errorResponse);
                }
            }
        });
    }

    protected Response processLocally(Request<?> inverseRequest) throws Exception {
        Objects.requireNonNull(inverseRequest, "inverseRequest");
        return this.rpcContext.getRpcServiceExecutor().processLocally(inverseRequest);
    }

    protected void putInverseResponse(Response inverseResponse) {
        Objects.requireNonNull(inverseResponse, "inverseResponse");
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            PutInverseResponseRequest request = new PutInverseResponseRequest();
            request.setServerHostId(HostId.SERVER);
            request.setInverseResponse(inverseResponse);
            rpcClient.invoke(request);
        }
        catch (Exception x) {
            logger.error("putInverseResponse: " + x + ' ', (Throwable)x);
        }
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
        super.interrupt();
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }
}

