/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.DeferredResponseRequest;
import house.intelli.core.rpc.DeferringResponse;
import house.intelli.core.rpc.Error;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.NullResponse;
import house.intelli.core.rpc.RemoteException;
import house.intelli.core.rpc.RemoteExceptionUtil;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RetriableError;
import house.intelli.core.rpc.RpcClientTransport;
import house.intelli.core.rpc.RpcClientTransportProvider;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcContextMode;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.RpcServiceExecutor;
import house.intelli.core.rpc.RpcTimeoutException;
import house.intelli.core.util.Util;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    private final RpcContext rpcContext;
    private final RpcClientTransportProvider rpcClientTransportProvider;
    private RpcClientTransport rpcClientTransport;

    protected RpcClient(RpcContext rpcContext) {
        this.rpcContext = Objects.requireNonNull(rpcContext, "rpcContext");
        this.rpcClientTransportProvider = RpcContextMode.CLIENT == rpcContext.getMode() ? Objects.requireNonNull(this.rpcContext.getRpcClientTransportProvider(), "rpcContext.rpcClientTransportProvider") : null;
    }

    public <REQ extends Request<RES>, RES extends Response> RES invoke(REQ request) throws RpcException {
        Objects.requireNonNull(request, "request");
        this.prepareRequest(request);
        long timeoutTimestamp = request.getCreated().getTime() + request.getTimeout();
        int retryCount = 0;
        int maxRetryCount = 3;
        while (true) {
            try {
                RES response = this._invoke(request);
                return response;
            }
            catch (Throwable x) {
                logger.error("invoke: " + x + ' ', x);
                if (System.currentTimeMillis() > timeoutTimestamp) {
                    throw x;
                }
                if (!this.isRetriableError(x) && !this.isRetriableRequest(request)) {
                    throw x;
                }
                if (++retryCount > 3) {
                    throw x;
                }
                logger.info("invoke: RETRYING! retryCount={}", (Object)retryCount);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    Util.doNothing();
                    continue;
                }
            }
            break;
        }
    }

    private boolean isRetriableRequest(Request<?> request) {
        return request.isIdempotent();
    }

    private boolean isRetriableError(Throwable x) {
        for (Throwable t = x; t != null; t = t.getCause()) {
            RetriableError annotation = t.getClass().getAnnotation(RetriableError.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return false;
    }

    protected <REQ extends Request<RES>, RES extends Response> RES _invoke(REQ request) throws RpcException {
        Objects.requireNonNull(request, "request");
        long timeoutTimestamp = request.getCreated().getTime() + request.getTimeout();
        DeferredResponseRequest deferredResponseRequest = null;
        try {
            Response response;
            while (true) {
                DeferredResponseRequest req = deferredResponseRequest != null ? deferredResponseRequest : (DeferredResponseRequest)request;
                logger.debug("invoke: Sending request: {}", req);
                if (RpcContextMode.CLIENT == this.rpcContext.getMode()) {
                    RpcClientTransport rpcClientTransport = this.getRpcClientTransport();
                    rpcClientTransport.sendRequest(req);
                    response = rpcClientTransport.receiveResponse();
                } else {
                    RpcServiceExecutor rpcServiceExecutor = this.rpcContext.getRpcServiceExecutor();
                    rpcServiceExecutor.putRequest(request);
                    response = rpcServiceExecutor.pollResponse(request.getRequestId(), request.getTimeout());
                    if (response == null) {
                        throw new RpcTimeoutException(String.format("Inverse request timed out: %s", request));
                    }
                }
                logger.debug("invoke: Received response: {}", (Object)response);
                if (!(response instanceof DeferringResponse)) break;
                if (System.currentTimeMillis() > timeoutTimestamp) {
                    throw new RpcTimeoutException(String.format("Request timed out: %s", request));
                }
                deferredResponseRequest = new DeferredResponseRequest();
                deferredResponseRequest.copyRequestCoordinates(request);
                deferredResponseRequest.setCreated(new Date());
                deferredResponseRequest.setTimeout(Math.max(1L, timeoutTimestamp - System.currentTimeMillis()));
            }
            if (response instanceof ErrorResponse) {
                ErrorResponse errorResponse = (ErrorResponse)response;
                Error error = Objects.requireNonNull(errorResponse.getError(), "errorResponse.error");
                RemoteExceptionUtil.throwOriginalExceptionIfPossible(error);
                throw new RemoteException(error);
            }
            if (response instanceof NullResponse) {
                return null;
            }
            Response res = response;
            return (RES)res;
        }
        catch (RpcException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RpcException(x);
        }
    }

    protected void prepareRequest(Request<?> request) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(request.getServerHostId(), "request.serverHostId");
        if (request.getClientHostId() == null) {
            request.setClientHostId(this.rpcContext.getLocalHostId());
        }
        if (request.getRequestId() == null) {
            request.setRequestId(new Uid());
        }
        if (request.getCreated() == null) {
            request.setCreated(new Date());
        }
        if (request.getTimeout() == 0L || request.getTimeout() < 0L) {
            request.setTimeout(600000L);
        }
    }

    public RpcClientTransport getRpcClientTransport() {
        if (this.rpcClientTransport == null) {
            this.rpcClientTransport = Objects.requireNonNull(this.rpcClientTransportProvider, "rpcClientTransportProvider").createRpcClientTransport();
        }
        return this.rpcClientTransport;
    }

    @Override
    public void close() {
        RpcClientTransport rct = this.rpcClientTransport;
        if (rct != null) {
            rct.close();
            this.rpcClientTransport = null;
        }
    }
}

