/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.InverseRequestRegistry;
import house.intelli.core.rpc.PollInverseRequestsThread;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcClientTransportProvider;
import house.intelli.core.rpc.RpcContextMode;
import house.intelli.core.rpc.RpcServer;
import house.intelli.core.rpc.RpcServiceExecutor;
import java.util.Objects;

public class RpcContext
implements AutoCloseable {
    private final RpcContextMode mode;
    private final HostId localHostId;
    private RpcClientTransportProvider rpcClientTransportProvider;
    private RpcServiceExecutor rpcServiceExecutor;
    private InverseRequestRegistry inverseRequestRegistry;
    private final PollInverseRequestsThread pollInverseRequestsThread;
    private volatile boolean closed;

    public RpcContext(RpcContextMode mode, HostId localHostId) {
        this.mode = Objects.requireNonNull(mode, "mode");
        this.localHostId = Objects.requireNonNull(localHostId, "localHostId");
        if (RpcContextMode.CLIENT == mode) {
            this.pollInverseRequestsThread = new PollInverseRequestsThread(this);
            this.pollInverseRequestsThread.start();
        } else {
            this.pollInverseRequestsThread = null;
        }
    }

    public RpcContext(RpcContextMode mode) {
        this(mode, HostId.getLocalHostId());
    }

    public RpcContextMode getMode() {
        return this.mode;
    }

    public HostId getLocalHostId() {
        return this.localHostId;
    }

    public RpcClientTransportProvider getRpcClientTransportProvider() {
        this.assertNotClosed();
        return this.rpcClientTransportProvider;
    }

    public void setRpcClientTransportProvider(RpcClientTransportProvider rpcClientTransportProvider) {
        this.assertNotClosed();
        if (rpcClientTransportProvider != null) {
            if (rpcClientTransportProvider.getRpcContext() != null && rpcClientTransportProvider.getRpcContext() != this) {
                throw new IllegalArgumentException("rpcClientTransportProvider is already bound to different RpcContext!");
            }
            rpcClientTransportProvider.setRpcContext(this);
        }
        this.rpcClientTransportProvider = rpcClientTransportProvider;
    }

    public RpcClient createRpcClient() {
        this.assertNotClosed();
        return new RpcClient(this);
    }

    public RpcServer createRpcServer() {
        this.assertNotClosed();
        if (RpcContextMode.SERVER != this.mode) {
            throw new IllegalStateException("RpcContextMode.SERVER != mode == " + (Object)((Object)this.mode));
        }
        return new RpcServer(this);
    }

    public synchronized RpcServiceExecutor getRpcServiceExecutor() {
        this.assertNotClosed();
        if (this.rpcServiceExecutor == null) {
            this.rpcServiceExecutor = new RpcServiceExecutor(this);
        }
        return this.rpcServiceExecutor;
    }

    public synchronized InverseRequestRegistry getInverseRequestRegistry() {
        this.assertNotClosed();
        if (this.inverseRequestRegistry == null) {
            this.inverseRequestRegistry = new InverseRequestRegistry(this);
        }
        return this.inverseRequestRegistry;
    }

    public boolean isServerLocal(Request<?> request) {
        Objects.requireNonNull(request, "request");
        this.assertNotClosed();
        HostId serverHostId = Objects.requireNonNull(request.getServerHostId(), "request.serverHostId");
        if (this.localHostId.equals(serverHostId)) {
            return true;
        }
        return RpcContextMode.SERVER == this.mode && HostId.SERVER.equals(serverHostId);
    }

    protected void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This RpcContext instance is already closed!");
        }
    }

    @Override
    public void close() {
        if (this.pollInverseRequestsThread != null) {
            this.pollInverseRequestsThread.interrupt();
        }
        this.closed = true;
    }
}

