/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.DeferredResponseRequest;
import house.intelli.core.rpc.DeferringResponse;
import house.intelli.core.rpc.Error;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.NullResponse;
import house.intelli.core.rpc.PollInverseRequestsRequest;
import house.intelli.core.rpc.PollInverseRequestsResponse;
import house.intelli.core.rpc.PutInverseResponseRequest;
import house.intelli.core.rpc.RemoteExceptionUtil;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.RpcServerTransport;
import house.intelli.core.rpc.RpcServiceExecutor;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(RpcServer.class);
    private final RpcContext rpcContext;
    private Request<?> request;
    private Response response;

    protected RpcServer(RpcContext rpcContext) {
        this.rpcContext = Objects.requireNonNull(rpcContext, "rpcContext");
    }

    public void receiveAndProcessRequest(RpcServerTransport rpcServerTransport) throws RpcException {
        Objects.requireNonNull(rpcServerTransport, "rpcServerTransport");
        if (rpcServerTransport.getRpcContext() != this.rpcContext) {
            throw new IllegalArgumentException("rpcServerTransport.rpcContext != this.rpcContext");
        }
        try {
            block7: {
                this.request = null;
                this.response = null;
                try {
                    this.request = rpcServerTransport.receiveRequest();
                    this.response = this.process(this.request);
                }
                catch (Exception x) {
                    logger.error("receiveAndProcessRequest: " + x + ' ', (Throwable)x);
                    Error error = RemoteExceptionUtil.createError(x);
                    this.response = new ErrorResponse(error);
                    if (this.request == null) break block7;
                    this.response.copyRequestCoordinates(this.request);
                }
            }
            Objects.requireNonNull(this.response, "response");
            rpcServerTransport.sendResponse(this.response);
        }
        catch (RpcException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RpcException(x);
        }
    }

    protected Response process(Request<?> request) {
        Objects.requireNonNull(request, "request");
        if (request.getTimeout() == 0L || request.getTimeout() < 0L) {
            request.setTimeout(600000L);
        }
        Uid requestId = Objects.requireNonNull(request.getRequestId(), "request.requestId");
        long timeout = Math.min(30000L, request.getTimeout());
        RpcServiceExecutor rpcServiceExecutor = this.rpcContext.getRpcServiceExecutor();
        if (request instanceof PollInverseRequestsRequest) {
            this.assertServerLocal(request);
            List<Request<?>> requests = this.rpcContext.getInverseRequestRegistry().pollRequests(request.getClientHostId(), timeout);
            PollInverseRequestsResponse response = new PollInverseRequestsResponse();
            response.setInverseRequests(requests);
            response.copyRequestCoordinates(request);
            return response;
        }
        if (request instanceof PutInverseResponseRequest) {
            this.assertServerLocal(request);
            PutInverseResponseRequest pirRequest = (PutInverseResponseRequest)request;
            Response inverseResponse = Objects.requireNonNull(pirRequest.getInverseResponse(), "putInverseResponseRequest.inverseResponse");
            rpcServiceExecutor.putResponse(inverseResponse);
            NullResponse response = new NullResponse();
            response.copyRequestCoordinates(request);
            return response;
        }
        if (request instanceof DeferredResponseRequest) {
            this.assertServerLocal(request);
        } else {
            rpcServiceExecutor.putRequest(request);
        }
        Response response = rpcServiceExecutor.pollResponse(requestId, timeout);
        if (response == null) {
            response = new DeferringResponse();
            response.copyRequestCoordinates(request);
        }
        return response;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public void close() {
    }

    protected void assertServerLocal(Request request) {
        Objects.requireNonNull(request, "request");
        if (!this.rpcContext.isServerLocal(request)) {
            throw new UnsupportedOperationException("This request's type is only supported for local processing, but its serverHostId references another host!" + request);
        }
    }
}

