/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.Uid;
import house.intelli.core.rpc.Error;
import house.intelli.core.rpc.ErrorResponse;
import house.intelli.core.rpc.NullResponse;
import house.intelli.core.rpc.RemoteExceptionUtil;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcMessage;
import house.intelli.core.rpc.RpcService;
import house.intelli.core.rpc.RpcServiceRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RpcServiceExecutor.class);
    private static final long EVICT_PERIOD = 3600000L;
    private final RpcContext rpcContext;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Object mutex = new Object();
    private final Map<Uid, Request> requestId2Request = new HashMap<Uid, Request>();
    private final Map<Uid, Response> requestId2Response = new HashMap<Uid, Response>();
    private final Map<Uid, EvictDescriptor> requestId2EvictDescriptor = new HashMap<Uid, EvictDescriptor>();
    private final Timer evictTimer;
    private final TimerTask evictTimerTask;

    protected RpcServiceExecutor(RpcContext rpcContext) {
        this.rpcContext = Objects.requireNonNull(rpcContext, "rpcContext");
        this.evictTimer = new Timer(String.format("RpcServiceExecutor[%s].evictTimer", rpcContext.getLocalHostId()), true);
        this.evictTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    RpcServiceExecutor.this.evict();
                }
                catch (Throwable x) {
                    logger.error("evictTimerTask.run: " + x + ' ', x);
                }
            }
        };
        this.evictTimer.schedule(this.evictTimerTask, 3600000L, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequest(final Request request) {
        Objects.requireNonNull(request, "request");
        Uid requestId = Objects.requireNonNull(request.getRequestId(), "request.requestId");
        Object object = this.mutex;
        synchronized (object) {
            if (this.requestId2Response.containsKey(requestId)) {
                throw new IllegalArgumentException("There is already a response with the same requestId! WTF?! requestId=" + requestId);
            }
            Request old = this.requestId2Request.put(requestId, request);
            if (old != null && old != request) {
                throw new IllegalArgumentException("There was already another request with the same requestId! WTF?! requestId=" + requestId);
            }
            this.requestId2EvictDescriptor.put(requestId, new EvictDescriptor(request));
            this.mutex.notifyAll();
        }
        if (this.putRequestIntoInverseRequestRegistryIfApplicable(request)) {
            return;
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response response = RpcServiceExecutor.this.rpcContext.isServerLocal(request) ? RpcServiceExecutor.this.processLocally(request) : RpcServiceExecutor.this.processRemotely(request);
                    RpcServiceExecutor.this.putResponse(response);
                }
                catch (Throwable x) {
                    Error error = RemoteExceptionUtil.createError(x);
                    ErrorResponse errorResponse = new ErrorResponse(error);
                    errorResponse.copyRequestCoordinates(request);
                    RpcServiceExecutor.this.putResponse(errorResponse);
                }
            }
        });
    }

    protected boolean putRequestIntoInverseRequestRegistryIfApplicable(Request request) {
        if (this.rpcContext.isServerLocal(request)) {
            return false;
        }
        switch (this.rpcContext.getMode()) {
            case CLIENT: {
                return false;
            }
            case SERVER: {
                this.rpcContext.getInverseRequestRegistry().putRequest(request);
                return true;
            }
        }
        throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.rpcContext.getMode()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Response processRemotely(Request request) throws Exception {
        try {
            switch (this.rpcContext.getMode()) {
                case CLIENT: {
                    try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
                        Object RES = rpcClient.invoke(request);
                        return RES;
                    }
                }
                case SERVER: {
                    throw new IllegalStateException("This should have been processed by putRequestIntoInverseRequestRegistryIfApplicable(...)!");
                }
            }
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.rpcContext.getMode()));
        }
        catch (Exception x) {
            logger.error("processLocally: " + x + ' ', (Throwable)x);
            throw x;
        }
    }

    public Response processLocally(Request request) throws Exception {
        try {
            RpcServiceRegistry rpcServiceRegistry = RpcServiceRegistry.getInstance();
            RpcService rpcService = rpcServiceRegistry.getRpcService(request.getClass());
            if (rpcService == null) {
                throw new IllegalArgumentException("There is no RpcService registered for this requestType: " + request.getClass().getName());
            }
            rpcService.setRpcContext(this.rpcContext);
            Object response = rpcService.process(request);
            if (response == null) {
                response = new NullResponse();
            }
            ((RpcMessage)response).copyRequestCoordinates(request);
            return response;
        }
        catch (Exception x) {
            logger.error("processLocally: " + x + ' ', (Throwable)x);
            throw x;
        }
    }

    public Response pollResponse(Uid requestId, long timeout) {
        Objects.requireNonNull(requestId, "requestId");
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout < 0");
        }
        long startTimestamp = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            while (true) {
                long elapsedTime;
                long remainingTime;
                do {
                    Response response;
                    if ((response = this.requestId2Response.remove(requestId)) != null) {
                        this.requestId2EvictDescriptor.remove(requestId);
                        return response;
                    }
                    elapsedTime = System.currentTimeMillis() - startTimestamp;
                    if (elapsedTime <= timeout) continue;
                    return null;
                } while ((remainingTime = timeout - elapsedTime) <= 0L);
                try {
                    this.mutex.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    logger.warn("pollResponse: " + e, (Throwable)e);
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putResponse(Response response) {
        Objects.requireNonNull(response, "response");
        Uid requestId = Objects.requireNonNull(response.getRequestId(), "response.requestId");
        Objects.requireNonNull(response.getClientHostId(), "response.clientHostId");
        Objects.requireNonNull(response.getServerHostId(), "response.serverHostId");
        Object object = this.mutex;
        synchronized (object) {
            Request request = this.requestId2Request.remove(requestId);
            if (request == null) {
                throw new IllegalArgumentException("There is no request waiting with requestId=" + requestId);
            }
            Response old = this.requestId2Response.put(requestId, response);
            if (old != null && old != response) {
                throw new IllegalArgumentException("There was already another response with the same requestId! WTF?! requestId=" + requestId);
            }
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        long now = System.currentTimeMillis();
        Object object = this.mutex;
        synchronized (object) {
            Iterator<EvictDescriptor> it = this.requestId2EvictDescriptor.values().iterator();
            while (it.hasNext()) {
                EvictDescriptor evictDescriptor = it.next();
                if (evictDescriptor.timeoutElapsed >= now) continue;
                this.requestId2Request.remove(evictDescriptor.requestId);
                this.requestId2Response.remove(evictDescriptor.requestId);
                it.remove();
            }
        }
    }

    private static class EvictDescriptor {
        public final Uid requestId;
        public final long created = System.currentTimeMillis();
        public final long timeout;
        public final long timeoutElapsed;

        public EvictDescriptor(Request request) {
            Objects.requireNonNull(request, "request");
            this.requestId = Objects.requireNonNull(request.getRequestId(), "request.requestId");
            this.timeout = request.getTimeout() == 0L ? 600000L : request.getTimeout();
            this.timeoutElapsed = this.created + this.timeout;
        }
    }
}

