/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc;

import house.intelli.core.jaxb.IntelliHouseJaxbContext;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.Response;
import house.intelli.core.rpc.RpcService;
import house.intelli.core.service.ServiceRegistry;
import house.intelli.core.service.ServiceRegistryListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RpcServiceRegistry {
    private final Object mutex = new Object();
    private final Map<Class<?>, List<RpcService<Request<?>, Response>>> requestType2RpcServices = new HashMap();
    private final ServiceRegistryListener<RpcService> serviceRegistryListener = event -> this.reset();
    private static final RpcServiceRegistry instance = new RpcServiceRegistry();
    private static Comparator<RpcService<?, ?>> rpcServiceComparator = new Comparator<RpcService<?, ?>>(){

        @Override
        public int compare(RpcService<?, ?> o1, RpcService<?, ?> o2) {
            int result = -1 * Integer.compare(o1.getPriority(), o2.getPriority());
            if (result != 0) {
                return result;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    };

    public static RpcServiceRegistry getInstance() {
        return instance;
    }

    protected RpcServiceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RpcService<?, ?>> getRpcServices() {
        ArrayList result = new ArrayList();
        Object object = this.mutex;
        synchronized (object) {
            if (this.requestType2RpcServices.isEmpty()) {
                this.load();
            }
            for (List<RpcService<Request<?>, Response>> services : this.requestType2RpcServices.values()) {
                for (RpcService<Request<?>, Response> service : services) {
                    result.add(service.clone());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <REQ extends Request<?>, RES extends Response> RpcService<REQ, RES> getRpcService(Class<? extends REQ> requestType) {
        Class<REQ> rt = Objects.requireNonNull(requestType, "requestType");
        Object object = this.mutex;
        synchronized (object) {
            if (this.requestType2RpcServices.isEmpty()) {
                this.load();
            }
            while (rt != Object.class) {
                List<RpcService<Request<?>, Response>> list = this.requestType2RpcServices.get(rt);
                if (list != null && !list.isEmpty()) {
                    RpcService<Request<?>, Response> rpcService = list.get(0);
                    RpcService<Request<?>, Response> result = rpcService.clone();
                    return result;
                }
                rt = rt.getSuperclass();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        HashMap requestType2RpcServices = new HashMap();
        ServiceRegistry<RpcService> serviceRegistry = ServiceRegistry.getInstance(RpcService.class);
        serviceRegistry.removeListener(this.serviceRegistryListener);
        serviceRegistry.addListener(this.serviceRegistryListener);
        for (RpcService rpcService : serviceRegistry.getServices()) {
            Class requestType = rpcService.getRequestType();
            ArrayList<RpcService> rpcServices = (ArrayList<RpcService>)requestType2RpcServices.get(requestType);
            if (rpcServices == null) {
                rpcServices = new ArrayList<RpcService>();
                requestType2RpcServices.put(requestType, rpcServices);
            }
            rpcServices.add(rpcService);
        }
        for (List list : requestType2RpcServices.values()) {
            Collections.sort(list, rpcServiceComparator);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.requestType2RpcServices.clear();
            this.requestType2RpcServices.putAll(requestType2RpcServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mutex;
        synchronized (object) {
            this.requestType2RpcServices.clear();
        }
        IntelliHouseJaxbContext.reset();
    }
}

