/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.rpc.echo;

import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.echo.EchoRequest;
import house.intelli.core.rpc.echo.EchoResponse;
import house.intelli.core.util.ReflectionUtil;
import house.intelli.core.util.StringUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EchoRpcService
extends AbstractRpcService<EchoRequest, EchoResponse> {
    private static final Logger logger = LoggerFactory.getLogger(EchoRpcService.class);

    @Override
    public EchoResponse process(EchoRequest request) throws Exception {
        String throwExceptionClassName;
        Objects.requireNonNull(request, "request");
        logger.info("process: {}", (Object)request);
        if (request.getSleep() > 0L) {
            Thread.sleep(request.getSleep());
        }
        if (!StringUtil.isEmpty(throwExceptionClassName = request.getThrowExceptionClassName())) {
            Exception exception;
            logger.info("process: throwing: {}", (Object)throwExceptionClassName);
            Class<?> exceptionClass = Class.forName(throwExceptionClassName);
            try {
                exception = (Exception)ReflectionUtil.invokeConstructor(exceptionClass, request.getPayload());
            }
            catch (Exception x) {
                exception = (Exception)ReflectionUtil.invokeConstructor(exceptionClass, new Object[0]);
            }
            throw exception;
        }
        EchoResponse response = new EchoResponse();
        response.setPayload(request.getPayload());
        logger.info("process: {}", (Object)response);
        return response;
    }
}

