/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.service;

import house.intelli.core.service.AbstractServiceRegistryDelegate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;

public class ServiceLoaderServiceRegistryDelegate<S>
extends AbstractServiceRegistryDelegate<S> {
    private final Class<S> serviceClass;

    public ServiceLoaderServiceRegistryDelegate(Class<S> serviceClass) {
        this.serviceClass = Objects.requireNonNull(serviceClass, "serviceClass");
    }

    public Class<S> getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public List<S> getServices() {
        Iterator<S> iterator = ServiceLoader.load(this.serviceClass, this.serviceClass.getClassLoader()).iterator();
        LinkedList<S> result = new LinkedList<S>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }
}

