/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.service;

import house.intelli.core.service.ServiceLoaderServiceRegistryDelegate;
import house.intelli.core.service.ServiceRegistryDelegate;
import house.intelli.core.service.ServiceRegistryEvent;
import house.intelli.core.service.ServiceRegistryListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistry<S> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceRegistry.class);
    private final Class<S> serviceClass;
    private static final Map<Class<?>, ServiceRegistry<?>> serviceClass2ServiceProvider = new HashMap();
    private final CopyOnWriteArrayList<ServiceRegistryDelegate<S>> delegates = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServiceRegistryListener<S>> listeners = new CopyOnWriteArrayList();

    protected ServiceRegistry(Class<S> serviceClass) {
        this.serviceClass = Objects.requireNonNull(serviceClass, "serviceClass");
        this.addDelegate(new ServiceLoaderServiceRegistryDelegate<S>(serviceClass));
    }

    public static synchronized <S> ServiceRegistry<S> getInstance(Class<S> serviceClass) {
        Objects.requireNonNull(serviceClass, "serviceClass");
        ServiceRegistry<Object> serviceProvider = serviceClass2ServiceProvider.get(serviceClass);
        if (serviceProvider == null) {
            serviceProvider = new ServiceRegistry<S>(serviceClass);
            serviceClass2ServiceProvider.put(serviceClass, serviceProvider);
        }
        return serviceProvider;
    }

    public Class<S> getServiceClass() {
        return this.serviceClass;
    }

    public void addDelegate(ServiceRegistryDelegate<S> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        logger.info("addDelegate: serviceClass={}, delegate={}", (Object)this.serviceClass.getName(), delegate);
        delegate.setServiceRegistry(this);
        this.delegates.add(delegate);
        this.fireServiceRegistryChanged();
    }

    public void removeDelegate(ServiceRegistryDelegate<S> delegate) {
        Objects.requireNonNull(delegate, "delegate");
        logger.info("removeDelegate: serviceClass={}, delegate={}", (Object)this.serviceClass.getName(), delegate);
        this.delegates.remove(delegate);
        this.fireServiceRegistryChanged();
        delegate.setServiceRegistry(null);
    }

    public void addListener(ServiceRegistryListener<S> listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.add(listener);
    }

    public void removeListener(ServiceRegistryListener<S> listener) {
        Objects.requireNonNull(listener, "listener");
        this.listeners.remove(listener);
    }

    protected void fireServiceRegistryEvent(ServiceRegistryEvent<S> event) {
        Objects.requireNonNull(event, "event");
        for (ServiceRegistryListener<S> listener : this.listeners) {
            listener.onServiceRegistryChanged(event);
        }
    }

    public void fireServiceRegistryChanged() {
        this.fireServiceRegistryEvent(new ServiceRegistryEvent(this));
    }

    public List<S> getServices() {
        ArrayList<S> result = new ArrayList<S>();
        for (ServiceRegistryDelegate<S> delegate : this.delegates) {
            List<S> services = delegate.getServices();
            if (logger.isInfoEnabled()) {
                ArrayList<String> serviceClassNames = new ArrayList<String>();
                for (S service : services) {
                    serviceClassNames.add(service.getClass().getName());
                }
                logger.info("getServices: delegateClass={}, serviceClasses={}", (Object)delegate.getClass().getName(), serviceClassNames);
            }
            result.addAll(services);
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }
}

