/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.core.util;

import house.intelli.core.progress.NullProgressMonitor;
import house.intelli.core.progress.ProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;

public final class HashUtil {
    public static final String HASH_ALGORITHM_MD5 = "MD5";
    public static final String HASH_ALGORITHM_SHA = "SHA";

    private HashUtil() {
    }

    public static String encodeHexStr(byte[] buf) {
        return HashUtil.encodeHexStr(buf, 0, buf.length);
    }

    public static String encodeHexStr(byte[] buf, int pos, int len) {
        StringBuilder hex = new StringBuilder();
        while (len-- > 0) {
            byte ch;
            int d;
            hex.append((char)((d = (ch = buf[pos++]) >> 4 & 0xF) >= 10 ? 87 + d : 48 + d));
            d = ch & 0xF;
            hex.append((char)(d >= 10 ? 87 + d : 48 + d));
        }
        return hex.toString();
    }

    public static byte[] decodeHexStr(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("The hex string must have an even number of characters!");
        }
        byte[] res = new byte[hex.length() / 2];
        int m = 0;
        for (int i = 0; i < hex.length(); i += 2) {
            res[m++] = (byte)Integer.parseInt(hex.substring(i, i + 2), 16);
        }
        return res;
    }

    public static byte[] hash(String algorithm, InputStream in) throws NoSuchAlgorithmException, IOException {
        return HashUtil.hash(algorithm, in, new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(String algorithm, InputStream in, ProgressMonitor monitor) throws NoSuchAlgorithmException, IOException {
        monitor.beginTask(algorithm, Math.max(1, in.available()));
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] data = new byte[10240];
            while ((bytesRead = in.read(data, 0, data.length)) >= 0) {
                if (bytesRead <= 0) continue;
                md.update(data, 0, bytesRead);
                monitor.worked(bytesRead);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            monitor.done();
        }
    }

    public static String formatEncodedHexStrForHuman(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("The hex string must have an even number of characters!");
        }
        hex = hex.toUpperCase(Locale.UK);
        StringBuilder sb = new StringBuilder(hex.length() * 3 / 2);
        for (int i = 0; i < hex.length(); i += 2) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(hex.substring(i, i + 2));
        }
        return sb.toString();
    }

    public static String sha1ForHuman(byte[] in) {
        try {
            return HashUtil.sha1ForHuman(new ByteArrayInputStream(in));
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static String sha1ForHuman(InputStream in) throws IOException {
        return HashUtil.formatEncodedHexStrForHuman(HashUtil.sha1(in));
    }

    public static String sha1(String in) {
        try {
            return HashUtil.sha1(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String sha1(byte[] in) {
        try {
            return HashUtil.sha1(new ByteArrayInputStream(in));
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    public static String sha1(InputStream in) throws IOException {
        byte[] hash;
        try {
            hash = HashUtil.hash(HASH_ALGORITHM_SHA, in);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return HashUtil.encodeHexStr(hash);
    }
}

