/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.AutoOff;
import house.intelli.raspi.AutoOffEvent;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

public class AutoOffSupport {
    public final AutoOff autoOff;
    private static final Timer autoOffTimer = new Timer("AutoOffSupport.autoOffTimer", true);
    private TimerTask autoOffTimerTask;

    public AutoOffSupport(AutoOff autoOff) {
        this.autoOff = Objects.requireNonNull(autoOff, "autoOff");
    }

    public void scheduleDeferredAutoOff() {
        int autoOffPeriod;
        AssertUtil.assertEventThread();
        if (this.autoOffTimerTask != null) {
            this.autoOffTimerTask.cancel();
            this.autoOffTimerTask = null;
        }
        if ((autoOffPeriod = this.autoOff.getAutoOffPeriod()) <= 0) {
            return;
        }
        this.autoOffTimerTask = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(() -> {
                    AutoOffSupport.this.autoOffTimerTask = null;
                    AutoOffEvent event = new AutoOffEvent(AutoOffSupport.this.autoOff);
                    AutoOffSupport.this.autoOff.onAutoOff(event);
                });
            }
        };
        autoOffTimer.schedule(this.autoOffTimerTask, (long)autoOffPeriod * 1000L);
    }

    public void cancelDeferredAutoOff() {
        AssertUtil.assertEventThread();
        if (this.autoOffTimerTask != null) {
            this.autoOffTimerTask.cancel();
            this.autoOffTimerTask = null;
        }
    }
}

