/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.wiringpi.Gpio;
import house.intelli.core.bean.AbstractBean;
import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.DimmerActor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimmerActorImpl
extends AbstractBean<DimmerActor.Property>
implements DimmerActor,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(DimmerActorImpl.class);
    private static final boolean USE_DIGITAL_OUTPUT_FOR_EXTREME_VALUES = false;
    private String beanName;
    private Pin pin;
    private GpioPinPwmOutput pwmOutput;
    private GpioPinDigitalOutput digitalOutput;
    private int dimmerValue = 0;
    public static final int[] PWM_VALUES = new int[]{0, 1, 2, 4, 8, 16, 32, 64, 100};

    public void init() {
        AssertUtil.assertEventThread();
        Objects.requireNonNull(this.pin, "pin");
        this.applyDimmerValue();
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        if (this.pin != null) {
            throw new IllegalStateException("pin already assigned!");
        }
        AssertUtil.assertEventThread();
        this.setPropertyValue(PropertyEnum.pin, pin);
    }

    @Override
    public int getDimmerValue() {
        AssertUtil.assertEventThread();
        return this.dimmerValue;
    }

    @Override
    public void setDimmerValue(int dimmerValue) {
        if (dimmerValue < 0) {
            throw new IllegalArgumentException("dimmerValue < MIN_DIMMER_VALUE");
        }
        if (dimmerValue > 100) {
            throw new IllegalArgumentException("dimmerValue > MAX_DIMMER_VALUE");
        }
        AssertUtil.assertEventThread();
        int pwmValueIndex = this.getPwmValueIndex(dimmerValue);
        dimmerValue = pwmValueIndex * 100 / (PWM_VALUES.length - 1);
        if (this.setPropertyValue(DimmerActor.PropertyEnum.dimmerValue, dimmerValue)) {
            this.applyDimmerValue();
        }
    }

    protected void applyDimmerValue() {
        this.openPwmOutput();
        this.pwmOutput.setPwm(this.getPwm());
    }

    protected int getPwm() {
        return PWM_VALUES[this.getPwmValueIndex(this.dimmerValue)];
    }

    private int getPwmValueIndex(int dimmerValue) {
        int pwmIndex = Math.round((float)dimmerValue * (float)(PWM_VALUES.length - 1) / 100.0f);
        return pwmIndex;
    }

    private void openPwmOutput() {
        AssertUtil.assertEventThread();
        if (this.pwmOutput != null) {
            return;
        }
        Objects.requireNonNull(this.pin, "pin");
        boolean hardPwm = this.pin.getSupportedPinModes().contains(PinMode.PWM_OUTPUT);
        this.logger.debug("openPwmOutput: hardPwm={}", (Object)hardPwm);
        this.closeDigitalOutput();
        GpioController gpioController = GpioFactory.getInstance();
        if (hardPwm) {
            this.pwmOutput = gpioController.provisionPwmOutputPin(this.pin);
            Gpio.pwmSetMode((int)1);
            Gpio.pwmSetClock((int)1920);
            Gpio.pwmSetRange((int)100);
        } else {
            this.pwmOutput = gpioController.provisionSoftPwmOutputPin(this.pin);
        }
    }

    private void openDigitalOutput() {
        AssertUtil.assertEventThread();
        if (this.digitalOutput != null) {
            return;
        }
        Objects.requireNonNull(this.pin, "pin");
        this.logger.debug("openDigitalOutput");
        this.closePwmOutput();
        GpioController gpioController = GpioFactory.getInstance();
        this.digitalOutput = gpioController.provisionDigitalOutputPin(this.pin);
    }

    private void closePwmOutput() {
        AssertUtil.assertEventThread();
        if (this.pwmOutput == null) {
            return;
        }
        this.logger.debug("closePwmOutput");
        GpioController gpioController = GpioFactory.getInstance();
        gpioController.unprovisionPin(new GpioPin[]{this.pwmOutput});
        this.pwmOutput = null;
    }

    private void closeDigitalOutput() {
        AssertUtil.assertEventThread();
        if (this.digitalOutput == null) {
            return;
        }
        this.logger.debug("closeDigitalOutput");
        GpioController gpioController = GpioFactory.getInstance();
        gpioController.unprovisionPin(new GpioPin[]{this.digitalOutput});
        this.digitalOutput = null;
    }

    @Override
    public void close() {
        this.logger.debug("close");
        EventQueue.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                DimmerActorImpl.this.closeDigitalOutput();
                DimmerActorImpl.this.closePwmOutput();
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }

    public static enum PropertyEnum implements DimmerActor.Property
    {
        pin;

    }
}

