/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import house.intelli.core.config.ConfigDir;
import house.intelli.core.event.EventQueue;
import house.intelli.core.jaxb.IntelliHouseJaxbContextProvider;
import house.intelli.core.rpc.RpcService;
import house.intelli.core.service.ServiceRegistry;
import house.intelli.core.util.IOUtil;
import house.intelli.core.util.Util;
import house.intelli.pgp.Pgp;
import house.intelli.pgp.PgpKey;
import house.intelli.pgp.PgpOwnerTrust;
import house.intelli.pgp.PgpRegistry;
import house.intelli.raspi.service.SpringServiceRegistryDelegate;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class IntelliHouseRaspi {
    public static void main(String[] args) throws Exception {
        IntelliHouseRaspi.initLogging();
        IntelliHouseRaspi.initUserHomeSpringContextFile();
        final Logger logger = LoggerFactory.getLogger(IntelliHouseRaspi.class);
        logger.info("Starting up...");
        EventQueue.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Creating Spring ApplicationContext...");
                    ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("META-INF/spring/spring-context.xml");
                    ServiceRegistry.getInstance(RpcService.class).addDelegate(new SpringServiceRegistryDelegate<RpcService>(RpcService.class, (ApplicationContext)applicationContext));
                    ServiceRegistry.getInstance(IntelliHouseJaxbContextProvider.class).addDelegate(new SpringServiceRegistryDelegate<IntelliHouseJaxbContextProvider>(IntelliHouseJaxbContextProvider.class, (ApplicationContext)applicationContext));
                    IntelliHouseRaspi.setupPgp();
                    logger.info("Created Spring ApplicationContext successfully.");
                }
                catch (Throwable x) {
                    logger.error("Creating Spring ApplicationContext failed: " + x + ' ', x);
                    System.exit(1);
                }
            }
        });
        while (!Thread.currentThread().isInterrupted()) {
            Thread.sleep(500L);
        }
    }

    private static void setupPgp() {
        try {
            Pgp pgp = PgpRegistry.getInstance().getPgpOrFail();
            for (PgpKey pgpKey : pgp.getMasterKeysWithSecretKey()) {
                pgp.setOwnerTrust(pgpKey, PgpOwnerTrust.ULTIMATE);
            }
            pgp.updateTrustDb();
        }
        catch (Throwable x) {
            LoggerFactory.getLogger(IntelliHouseRaspi.class).warn("setupPgp: " + x + ' ', x);
        }
    }

    private static void initLogging() throws IOException, JoranException {
        ConfigDir.getInstance().getLogDir();
        String logbackXmlName = "logback.xml";
        File logbackXmlFile = new File(ConfigDir.getInstance().getFile(), "logback.xml");
        if (!logbackXmlFile.exists()) {
            IOUtil.copyResource(IntelliHouseRaspi.class, (String)"logback.xml", (File)logbackXmlFile);
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(logbackXmlFile);
        }
        catch (JoranException je) {
            Util.doNothing();
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    private static void initUserHomeSpringContextFile() throws IOException {
        String springContextLocalName = "spring-context-local.xml";
        File springContextLocalFile = new File(ConfigDir.getInstance().getFile(), "spring-context-local.xml");
        if (!springContextLocalFile.exists()) {
            IOUtil.copyResource(IntelliHouseRaspi.class, (String)"spring-context-local.xml", (File)springContextLocalFile);
        }
    }
}

