/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import house.intelli.core.bean.AbstractBean;
import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.KeyButtonSensor;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.beans.factory.BeanNameAware;

public class KeyButtonSensorImpl
extends AbstractBean<KeyButtonSensor.Property>
implements KeyButtonSensor,
AutoCloseable,
BeanNameAware {
    private static final long DEBOUNCE_PERIOD = 100L;
    private String beanName;
    private Pin pin;
    private boolean inverse;
    private GpioPinDigitalInput digitalInput;
    private boolean down;
    private PinState debounceCandidatePinState;
    private final Timer debounceTimer = new Timer("KeyButtonSensorImpl.debounceTimer@" + Integer.toHexString(System.identityHashCode(this)), true);
    private TimerTask debounceTimerTask;
    private GpioPinListenerDigital listener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            PinState state = event.getState();
            EventQueue.invokeLater(() -> KeyButtonSensorImpl.this.setDebounceCandidatePinState(state));
        }
    };

    private void setDebounceCandidatePinState(PinState state) {
        Objects.requireNonNull(state, "state");
        AssertUtil.assertEventThread();
        if (this.debounceCandidatePinState == state) {
            return;
        }
        this.debounceCandidatePinState = state;
        this.scheduleDebounceTimerTask();
    }

    private void scheduleDebounceTimerTask() {
        AssertUtil.assertEventThread();
        if (this.debounceTimerTask != null) {
            this.debounceTimerTask.cancel();
            this.debounceTimerTask = null;
        }
        this.debounceTimerTask = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater(() -> {
                    KeyButtonSensorImpl.this.debounceTimerTask = null;
                    PinState state = KeyButtonSensorImpl.this.digitalInput.getState();
                    if (state == KeyButtonSensorImpl.this.debounceCandidatePinState) {
                        KeyButtonSensorImpl.this._setDown(state);
                    } else {
                        KeyButtonSensorImpl.this.setDebounceCandidatePinState(state);
                    }
                });
            }
        };
        this.debounceTimer.schedule(this.debounceTimerTask, 100L);
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.setPropertyValue(KeyButtonSensor.PropertyEnum.beanName, beanName);
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        if (this.pin != null) {
            throw new IllegalStateException("pin already assigned!");
        }
        AssertUtil.assertEventThread();
        this.setPropertyValue(PropertyEnum.pin, pin);
    }

    public void init() {
        AssertUtil.assertEventThread();
        Objects.requireNonNull(this.pin, "pin");
        this.openDigitalInput();
    }

    @Override
    public boolean isDown() {
        AssertUtil.assertEventThread();
        return this.down;
    }

    @Override
    public void setDown(boolean down) {
        AssertUtil.assertEventThread();
        this.setPropertyValue(KeyButtonSensor.PropertyEnum.down, down);
    }

    protected void _setDown(PinState pinState) {
        if (this.isInverse()) {
            this.setDown(PinState.LOW == pinState);
        } else {
            this.setDown(PinState.HIGH == pinState);
        }
    }

    public boolean isInverse() {
        AssertUtil.assertEventThread();
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        AssertUtil.assertEventThread();
        this.setPropertyValue(PropertyEnum.inverse, inverse);
    }

    private void openDigitalInput() {
        if (this.digitalInput != null) {
            return;
        }
        AssertUtil.assertEventThread();
        Objects.requireNonNull(this.pin, "pin");
        GpioController gpioController = GpioFactory.getInstance();
        this.digitalInput = gpioController.provisionDigitalInputPin(this.pin);
        this.digitalInput.setDebounce(0);
        this.digitalInput.setPullResistance(PinPullResistance.OFF);
        this.digitalInput.addListener(new GpioPinListener[]{this.listener});
        this._setDown(this.digitalInput.getState());
    }

    private void closeDigitalInput() {
        AssertUtil.assertEventThread();
        if (this.digitalInput == null) {
            return;
        }
        this.digitalInput.removeListener(new GpioPinListener[]{this.listener});
        GpioController gpioController = GpioFactory.getInstance();
        gpioController.unprovisionPin(new GpioPin[]{this.digitalInput});
        this.digitalInput = null;
    }

    @Override
    public void close() {
        EventQueue.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                KeyButtonSensorImpl.this.closeDigitalInput();
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }

    public static enum PropertyEnum implements KeyButtonSensor.Property
    {
        pin,
        inverse;

    }
}

