/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import house.intelli.core.bean.AbstractBean;
import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.lightcontroller.DimDirection;
import house.intelli.core.rpc.lightcontroller.LightControllerState;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.AutoOff;
import house.intelli.raspi.AutoOffEvent;
import house.intelli.raspi.AutoOffSupport;
import house.intelli.raspi.DimmerActor;
import house.intelli.raspi.KeyButtonSensor;
import house.intelli.raspi.LightController;
import house.intelli.raspi.RelayActor;
import house.intelli.raspi.Remote;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightControllerImpl
extends AbstractBean<DimmerActor.Property>
implements LightController,
AutoOff,
AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(LightControllerImpl.class);
    public static final int[] LIGHT_DIMMER_VALUES = new int[]{12, 25, 37, 50, 62, 75, 87, 100};
    private String beanName;
    private int lightDimmerValuesIndex = -1;
    private Boolean lightOn;
    private List<KeyButtonSensor> keyButtons = new ArrayList<KeyButtonSensor>();
    private List<DimmerActor> lights = new ArrayList<DimmerActor>();
    private List<RelayActor> powerSupplies = new ArrayList<RelayActor>();
    private boolean switchOffOnKeyButtonUp;
    private DimDirection dimDirection = DimDirection.DOWN;
    private int dimmerValue;
    private static final Timer timer = new Timer("LightControllerImpl.timer", true);
    private TimerTask timerTask;
    private int autoOffPeriod;
    private final AutoOffSupport autoOffSupport = new AutoOffSupport(this);
    private List<RemoteBeanRef> federatedLightControllers = new ArrayList<RemoteBeanRef>();
    private final Set<RemoteBeanRef> collectedFederatedLightControllers = new CopyOnWriteArraySet<RemoteBeanRef>();
    private LightControllerState state;
    private boolean ignoreUpdateState;
    private final PropertyChangeListener keyButtonDownListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean down = (Boolean)evt.getNewValue();
            if (down) {
                LightControllerImpl.this.onKeyButtonDown();
            } else {
                LightControllerImpl.this.onKeyButtonUp();
            }
        }
    };
    private final PropertyChangeListener dimmerValueListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LightControllerImpl.this.onDimmerValueChange();
        }
    };

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public List<KeyButtonSensor> getKeyButtons() {
        return this.keyButtons;
    }

    public void setKeyButtons(List<KeyButtonSensor> keyButtonSensors) {
        this.keyButtons = keyButtonSensors == null ? new ArrayList() : keyButtonSensors;
    }

    public List<DimmerActor> getLights() {
        return this.lights;
    }

    public void setLights(List<DimmerActor> lights) {
        this.lights = lights == null ? new ArrayList() : lights;
    }

    public List<RelayActor> getPowerSupplies() {
        return this.powerSupplies;
    }

    public void setPowerSupplies(List<RelayActor> powerSupplies) {
        this.powerSupplies = powerSupplies == null ? new ArrayList() : powerSupplies;
    }

    public List<RemoteBeanRef> getFederatedLightControllers() {
        return this.federatedLightControllers;
    }

    public void setFederatedLightControllers(List<RemoteBeanRef> federatedLightControllers) {
        AssertUtil.assertEventThread();
        this.collectedFederatedLightControllers.removeAll(this.federatedLightControllers);
        this.federatedLightControllers = Collections.unmodifiableList(federatedLightControllers == null ? new ArrayList() : federatedLightControllers);
        this.collectedFederatedLightControllers.addAll(this.federatedLightControllers);
    }

    public Set<RemoteBeanRef> getCollectedFederatedLightControllers() {
        return this.collectedFederatedLightControllers;
    }

    protected boolean isSwitchOffOnKeyButtonUp() {
        AssertUtil.assertEventThread();
        return this.switchOffOnKeyButtonUp;
    }

    protected void setSwitchOffOnKeyButtonUp(boolean switchOffOnKeyButtonUp) {
        AssertUtil.assertEventThread();
        this.setPropertyValue(LightController.PropertyEnum.switchOffOnKeyButtonUp, switchOffOnKeyButtonUp);
    }

    protected DimDirection getDimDirection() {
        return this.dimDirection;
    }

    protected void setDimDirection(DimDirection dimDirection) {
        Objects.requireNonNull(dimDirection, "dimDirection");
        this.setPropertyValue(LightController.PropertyEnum.dimDirection, dimDirection);
    }

    private void onKeyButtonDown() {
        AssertUtil.assertEventThread();
        this.logger.debug("onKeyButtonDown");
        if (this.isLightOn()) {
            this.setSwitchOffOnKeyButtonUp(true);
        } else {
            this.setLightOn(true);
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                EventQueue.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LightControllerImpl.this.onTimerTaskRun();
                    }
                });
            }
        };
        timer.schedule(this.timerTask, 1000L, 1000L);
    }

    private void onTimerTaskRun() {
        AssertUtil.assertEventThread();
        this.logger.debug("onTimerTaskRun");
        this.setSwitchOffOnKeyButtonUp(false);
        int lightDimmerValuesIndex = this.getLightDimmerValuesIndex();
        if (this.getDimDirection() == DimDirection.DOWN) {
            if (--lightDimmerValuesIndex < 0) {
                this.setDimDirection(DimDirection.UP);
                ++lightDimmerValuesIndex;
            }
        } else if (++lightDimmerValuesIndex >= LIGHT_DIMMER_VALUES.length) {
            this.setDimDirection(DimDirection.DOWN);
            --lightDimmerValuesIndex;
        }
        this.setLightDimmerValuesIndex(lightDimmerValuesIndex);
    }

    private void onKeyButtonUp() {
        AssertUtil.assertEventThread();
        this.logger.debug("onKeyButtonUp");
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.isSwitchOffOnKeyButtonUp()) {
            this.setSwitchOffOnKeyButtonUp(false);
            this.setLightOn(false);
        } else if (this.getDimDirection() == DimDirection.DOWN) {
            this.setDimDirection(DimDirection.UP);
        } else {
            this.setDimDirection(DimDirection.DOWN);
        }
    }

    private void onDimmerValueChange() {
        AssertUtil.assertEventThread();
        boolean energized = false;
        for (DimmerActor light : this.lights) {
            int dimmerValue = light.getDimmerValue();
            if (0 == dimmerValue) continue;
            energized = true;
        }
        for (RelayActor powerSupply : this.powerSupplies) {
            powerSupply.setEnergized(energized);
        }
        if (energized) {
            this.autoOffSupport.scheduleDeferredAutoOff();
        } else {
            this.autoOffSupport.cancelDeferredAutoOff();
        }
    }

    public void init() {
        AssertUtil.assertEventThread();
        this.keyButtons = Collections.unmodifiableList(this.keyButtons);
        this.lights = Collections.unmodifiableList(this.lights);
        this.powerSupplies = Collections.unmodifiableList(this.powerSupplies);
        for (KeyButtonSensor keyButton : this.keyButtons) {
            keyButton.addPropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.keyButtonDownListener);
        }
        for (DimmerActor light : this.lights) {
            light.addPropertyChangeListener(DimmerActor.PropertyEnum.dimmerValue, this.dimmerValueListener);
        }
        this.setLightOn(false);
        this.setLightDimmerValuesIndex(LIGHT_DIMMER_VALUES.length - 1);
    }

    protected int getLightDimmerValuesIndex() {
        AssertUtil.assertEventThread();
        return this.lightDimmerValuesIndex;
    }

    protected void setLightDimmerValuesIndex(int lightDimmerValuesIndex) {
        AssertUtil.assertEventThread();
        if (lightDimmerValuesIndex < 0 || lightDimmerValuesIndex >= LIGHT_DIMMER_VALUES.length) {
            throw new IllegalArgumentException("lightDimmerValuesIndex out of range!");
        }
        this.setPropertyValue(LightController.PropertyEnum.lightDimmerValuesIndex, lightDimmerValuesIndex);
        this.setPropertyValue(DimmerActor.PropertyEnum.dimmerValue, LIGHT_DIMMER_VALUES[lightDimmerValuesIndex]);
        this.applyLightsDimmerValue();
    }

    public boolean isLightOn() {
        AssertUtil.assertEventThread();
        return this.lightOn != null && this.lightOn != false;
    }

    public void setLightOn(boolean lightOn) {
        AssertUtil.assertEventThread();
        if (this.setPropertyValue(LightController.PropertyEnum.lightOn, lightOn)) {
            this._setDimmerValue(lightOn ? LIGHT_DIMMER_VALUES[this.lightDimmerValuesIndex] : 0);
            this.applyLightsDimmerValue();
        }
    }

    private void applyLightsDimmerValue() {
        AssertUtil.assertEventThread();
        for (DimmerActor light : this.lights) {
            if (light instanceof Remote) continue;
            light.setDimmerValue(this.isLightOn() ? LIGHT_DIMMER_VALUES[this.lightDimmerValuesIndex] : 0);
        }
        if (this.isLightOn()) {
            this.autoOffSupport.scheduleDeferredAutoOff();
        } else {
            this.autoOffSupport.cancelDeferredAutoOff();
        }
        this.updateState();
    }

    @Override
    public int getAutoOffPeriod() {
        return this.autoOffPeriod;
    }

    @Override
    public void setAutoOffPeriod(int autoOffPeriod) {
        AssertUtil.assertEventThread();
        this.autoOffPeriod = autoOffPeriod;
    }

    @Override
    public void onAutoOff(AutoOffEvent event) {
        this.setLightOn(false);
    }

    @Override
    public void close() {
        EventQueue.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                LightControllerImpl.this._close();
            }
        });
    }

    protected void _close() {
        AssertUtil.assertEventThread();
        for (KeyButtonSensor keyButton : this.keyButtons) {
            keyButton.removePropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.keyButtonDownListener);
        }
        for (DimmerActor light : this.lights) {
            light.removePropertyChangeListener(DimmerActor.PropertyEnum.dimmerValue, this.dimmerValueListener);
        }
        this.keyButtons = new ArrayList<KeyButtonSensor>(this.keyButtons);
        this.lights = new ArrayList<DimmerActor>(this.lights);
        this.powerSupplies = new ArrayList<RelayActor>(this.powerSupplies);
    }

    @Override
    public int getDimmerValue() {
        return this.dimmerValue;
    }

    @Override
    public void setDimmerValue(int dimmerValue) {
        if (this.getDimmerValue() == dimmerValue) {
            this.logger.debug("setDimmerValue: ignoring: bean={} old=dimmerValue={}", (Object)this, (Object)dimmerValue);
            return;
        }
        if (dimmerValue < 0) {
            throw new IllegalArgumentException("dimmerValue < MIN_DIMMER_VALUE");
        }
        if (dimmerValue > 100) {
            throw new IllegalArgumentException("dimmerValue > MAX_DIMMER_VALUE");
        }
        if (dimmerValue == 0) {
            this._setDimmerValue(dimmerValue);
            this.setLightOn(false);
            return;
        }
        int bestDistance = Integer.MAX_VALUE;
        int bestIndex = -1;
        for (int i = 0; i < LIGHT_DIMMER_VALUES.length; ++i) {
            int d = Math.abs(LIGHT_DIMMER_VALUES[i] - dimmerValue);
            if (d >= bestDistance) continue;
            bestDistance = d;
            bestIndex = i;
        }
        this._setDimmerValue(dimmerValue);
        this.setLightDimmerValuesIndex(bestIndex);
        this.setLightOn(true);
    }

    protected void _setDimmerValue(int dimmerValue) {
        this.setPropertyValue(DimmerActor.PropertyEnum.dimmerValue, dimmerValue);
    }

    public LightControllerState getState() {
        if (this.state == null) {
            this.updateState();
        }
        return Objects.requireNonNull(this.state, "state");
    }

    public void setState(LightControllerState state) {
        Objects.requireNonNull(state, "state");
        LightControllerState oldState = this.getState();
        if (oldState.equals((Object)state)) {
            return;
        }
        this.logger.debug("setState: oldState={}, state={}", (Object)oldState, (Object)state);
        this.ignoreUpdateState = true;
        try {
            this.setAutoOffPeriod(Math.max(state.getAutoOffPeriod(), state.getAutoOffPeriod()));
            this.setLightDimmerValuesIndex(state.getLightDimmerValuesIndex());
            if (state.getLightOn() != null) {
                this.setLightOn(state.getLightOn());
            }
            this.setDimDirection(state.getDimDirection());
            this._setState(state);
        }
        finally {
            this.ignoreUpdateState = false;
        }
    }

    protected void _setState(LightControllerState state) {
        this.setPropertyValue(LightController.PropertyEnum.state, state);
    }

    protected void updateState() {
        if (this.ignoreUpdateState) {
            return;
        }
        LightControllerState state = new LightControllerState();
        state.setAutoOffPeriod(this.autoOffPeriod);
        state.setDimDirection(this.dimDirection);
        state.setDimmerValue(this.dimmerValue);
        state.setLightDimmerValuesIndex(this.lightDimmerValuesIndex);
        state.setLightOn(this.lightOn);
        this._setState(state);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }
}

