/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import house.intelli.core.bean.AbstractBean;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.RelayActor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.BeanNameAware;

public abstract class RelayActorGroup
extends AbstractBean<RelayActor.Property>
implements BeanNameAware {
    private String beanName;
    private List<RelayActor> input = new ArrayList<RelayActor>();
    private RelayActor output;
    private final PropertyChangeListener inputEnergizedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            RelayActor inputRelayActor = (RelayActor)event.getSource();
            Boolean oldEnergized = (Boolean)event.getOldValue();
            Boolean newEnergized = (Boolean)event.getNewValue();
            RelayActorGroup.this.onInputEnergizedChanged(Objects.requireNonNull(inputRelayActor, "inputRelayActor"), Objects.requireNonNull(oldEnergized, "oldEnergized"), Objects.requireNonNull(newEnergized, "newEnergized"));
        }
    };

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public List<RelayActor> getInput() {
        return this.input;
    }

    public void setInput(List<RelayActor> input) {
        this.input = input == null ? new ArrayList() : input;
    }

    public RelayActor getOutput() {
        return this.output;
    }

    public void setOutput(RelayActor output) {
        this.output = output;
    }

    public void init() {
        AssertUtil.assertEventThread();
        for (RelayActor inputRelayActor : this.getInput()) {
            inputRelayActor.addPropertyChangeListener(RelayActor.PropertyEnum.energized, this.inputEnergizedListener);
        }
    }

    protected abstract void onInputEnergizedChanged(RelayActor var1, boolean var2, boolean var3);

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }
}

