/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import house.intelli.core.bean.AbstractBean;
import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.RelayActor;
import java.util.Objects;

public class RelayActorImpl
extends AbstractBean<RelayActor.Property>
implements RelayActor,
AutoCloseable {
    private String beanName;
    private Pin pin;
    private GpioPinDigitalOutput digitalOutput;
    private boolean energized;

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        if (this.pin != null) {
            throw new IllegalStateException("pin already assigned!");
        }
        this.setPropertyValue(PropertyEnum.pin, pin);
    }

    public void init() {
        Objects.requireNonNull(this.pin, "pin");
        this.applyEnergized();
    }

    @Override
    public boolean isEnergized() {
        AssertUtil.assertEventThread();
        return this.energized;
    }

    @Override
    public void setEnergized(boolean energized) {
        AssertUtil.assertEventThread();
        if (this.setPropertyValue(RelayActor.PropertyEnum.energized, energized)) {
            this.applyEnergized();
        }
    }

    protected void applyEnergized() {
        this.openDigitalOutput();
        if (this.energized) {
            this.digitalOutput.setState(PinState.HIGH);
        } else {
            this.digitalOutput.setState(PinState.LOW);
        }
    }

    private void openDigitalOutput() {
        AssertUtil.assertEventThread();
        if (this.digitalOutput != null) {
            return;
        }
        Objects.requireNonNull(this.pin, "pin");
        GpioController gpioController = GpioFactory.getInstance();
        this.digitalOutput = gpioController.provisionDigitalOutputPin(this.pin);
    }

    private void closeDigitalOutput() {
        AssertUtil.assertEventThread();
        if (this.digitalOutput == null) {
            return;
        }
        GpioController gpioController = GpioFactory.getInstance();
        gpioController.unprovisionPin(new GpioPin[]{this.digitalOutput});
        this.digitalOutput = null;
    }

    @Override
    public void close() {
        EventQueue.invokeAndWait(() -> this.closeDigitalOutput());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }

    public static enum PropertyEnum implements RelayActor.Property
    {
        pin;

    }
}

