/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import house.intelli.core.bean.AbstractBean;
import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.AutoOff;
import house.intelli.raspi.AutoOffEvent;
import house.intelli.raspi.AutoOffSupport;
import house.intelli.raspi.KeyButtonSensor;
import house.intelli.raspi.KeyButtonSensorImpl;
import house.intelli.raspi.RelayActor;
import house.intelli.raspi.RelayActorImpl;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;

public class RelayControllerImpl
extends AbstractBean<RelayActor.Property>
implements RelayActor,
AutoOff,
AutoCloseable,
BeanNameAware {
    private final Logger logger = LoggerFactory.getLogger(RelayControllerImpl.class);
    private String beanName;
    private List<KeyButtonSensorImpl> keyButtons = new ArrayList<KeyButtonSensorImpl>();
    private List<RelayActorImpl> powerSupplies = new ArrayList<RelayActorImpl>();
    private boolean latching;
    private boolean inverse;
    private int downCount;
    private boolean down;
    private boolean energized;
    private int autoOffPeriod;
    private final AutoOffSupport autoOffSupport = new AutoOffSupport(this);
    private final PropertyChangeListener keyButtonDownListener = event -> {
        AssertUtil.assertEventThread();
        boolean down = (Boolean)event.getNewValue();
        if (down) {
            this.onKeyButtonDown();
        } else {
            this.onKeyButtonUp();
        }
    };

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public List<KeyButtonSensorImpl> getKeyButtons() {
        return this.keyButtons;
    }

    public void setKeyButtons(List<KeyButtonSensorImpl> keyButtonSensorImpls) {
        this.keyButtons = keyButtonSensorImpls == null ? new ArrayList() : keyButtonSensorImpls;
    }

    public List<RelayActorImpl> getPowerSupplies() {
        return this.powerSupplies;
    }

    public void setPowerSupplies(List<RelayActorImpl> powerSupplies) {
        this.powerSupplies = powerSupplies == null ? new ArrayList() : powerSupplies;
    }

    public void init() {
        AssertUtil.assertEventThread();
        this.keyButtons = Collections.unmodifiableList(this.keyButtons);
        this.powerSupplies = Collections.unmodifiableList(this.powerSupplies);
        int downCount = 0;
        for (KeyButtonSensorImpl keyButton : this.keyButtons) {
            keyButton.addPropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.keyButtonDownListener);
            if (!keyButton.isDown()) continue;
            ++downCount;
        }
        this.setDownCount(downCount);
        this.applyDown(this.isDown());
    }

    private void onKeyButtonDown() {
        AssertUtil.assertEventThread();
        this.logger.debug("onKeyButtonDown");
        this.setDownCount(this.getDownCount() + 1);
    }

    private void onKeyButtonUp() {
        AssertUtil.assertEventThread();
        this.logger.debug("onKeyButtonUp");
        this.setDownCount(this.getDownCount() - 1);
    }

    public boolean isLatching() {
        AssertUtil.assertEventThread();
        return this.latching;
    }

    public void setLatching(boolean latching) {
        AssertUtil.assertEventThread();
        this.setPropertyValue(PropertyEnum.latching, latching);
    }

    public boolean isInverse() {
        AssertUtil.assertEventThread();
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        AssertUtil.assertEventThread();
        this.setPropertyValue(PropertyEnum.inverse, inverse);
    }

    public boolean isDown() {
        AssertUtil.assertEventThread();
        return this.down;
    }

    protected void setDown(boolean down) {
        AssertUtil.assertEventThread();
        if (this.setPropertyValue(PropertyEnum.down, down)) {
            this.applyDown(down);
        }
    }

    public int getDownCount() {
        AssertUtil.assertEventThread();
        return this.downCount;
    }

    protected void setDownCount(int downCount) {
        AssertUtil.assertEventThread();
        if (downCount < 0) {
            throw new IllegalArgumentException("downCount < 0");
        }
        this.setPropertyValue(PropertyEnum.downCount, downCount);
        this.setDown(downCount > 0);
    }

    @Override
    public boolean isEnergized() {
        AssertUtil.assertEventThread();
        return this.energized;
    }

    @Override
    public void setEnergized(boolean energized) {
        AssertUtil.assertEventThread();
        if (this.setPropertyValue(PropertyEnum.energized, energized)) {
            this.applyEnergized(energized);
        }
    }

    @Override
    public int getAutoOffPeriod() {
        return this.autoOffPeriod;
    }

    @Override
    public void setAutoOffPeriod(int autoOffPeriod) {
        AssertUtil.assertEventThread();
        this.autoOffPeriod = autoOffPeriod;
    }

    protected void applyDown(boolean down) {
        AssertUtil.assertEventThread();
        if (this.isLatching()) {
            boolean energized = this.isInverse() ? !down : down;
            this.setEnergized(energized);
        } else if (down) {
            this.setEnergized(!this.isEnergized());
        }
    }

    private void applyEnergized(boolean energized) {
        AssertUtil.assertEventThread();
        for (RelayActorImpl powerSupply : this.powerSupplies) {
            powerSupply.setEnergized(energized);
        }
        if (energized) {
            this.autoOffSupport.scheduleDeferredAutoOff();
        } else {
            this.autoOffSupport.cancelDeferredAutoOff();
        }
    }

    @Override
    public void onAutoOff(AutoOffEvent event) {
        this.setEnergized(false);
    }

    @Override
    public void close() {
        EventQueue.invokeAndWait(() -> this._close());
    }

    protected void _close() {
        AssertUtil.assertEventThread();
        for (KeyButtonSensorImpl keyButton : this.keyButtons) {
            keyButton.removePropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.keyButtonDownListener);
        }
        this.keyButtons = new ArrayList<KeyButtonSensorImpl>(this.keyButtons);
        this.powerSupplies = new ArrayList<RelayActorImpl>(this.powerSupplies);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.toString_getProperties() + ']';
    }

    protected String toString_getProperties() {
        return "beanName=" + this.beanName;
    }

    public static enum PropertyEnum implements RelayActor.Property
    {
        latching,
        inverse,
        downCount,
        down,
        energized;

    }
}

