/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi;

import house.intelli.core.bean.AbstractBean;
import house.intelli.core.config.ConfigDir;
import house.intelli.core.event.EventQueue;
import house.intelli.core.util.AssertUtil;
import house.intelli.core.util.StringUtil;
import house.intelli.raspi.PvDataCollector;
import house.intelli.raspi.StecaInterfaceType;
import house.intelli.raspi.pv.DataCollectorEvent;
import house.intelli.raspi.pv.DataCollectorListener;
import house.intelli.raspi.pv.steca.GetInverterMode;
import house.intelli.raspi.pv.steca.GetInverterStatus;
import house.intelli.raspi.pv.steca.InverterMode;
import house.intelli.raspi.pv.steca.InverterStatus;
import house.intelli.raspi.pv.steca.StecaClient;
import house.intelli.raspi.pv.steca.StecaClientRxTx;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StecaDataCollectorImpl
extends AbstractBean<PvDataCollector.Property>
implements PvDataCollector,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(StecaDataCollectorImpl.class);
    protected static final StecaInterfaceType DEFAULT_INTERFACE_TYPE = StecaInterfaceType.RXTX;
    private String beanName;
    private String deviceName;
    private StecaInterfaceType interfaceType;
    private String interfaceAddress;
    private volatile StecaClient stecaClient;
    private long collectPeriod = 1000L;
    private Timer dataCollectorTimer;
    private TimerTask dataCollectorTimerTask;
    private CopyOnWriteArrayList<DataCollectorListener> dataCollectorListeners = new CopyOnWriteArrayList();
    private volatile int consecutiveErrorCount;
    private int resetUsbAfterConsecutiveErrorCount;

    public void init() {
        AssertUtil.assertEventThread();
        if (StringUtil.isEmpty((String)this.getDeviceName())) {
            throw new IllegalStateException(String.format("%s: deviceName not specified!", this.getBeanInstanceName()));
        }
        if (this.getInterfaceType() == null) {
            logger.info("init: bean={}: interfaceType no specified! Setting default value {}.", (Object)this.getBeanInstanceName(), (Object)DEFAULT_INTERFACE_TYPE);
            this.setInterfaceType(DEFAULT_INTERFACE_TYPE);
        }
        if (StringUtil.isEmpty((String)this.getInterfaceAddress())) {
            throw new IllegalStateException(String.format("%s: interfaceAddress not specified!", this.getBeanInstanceName()));
        }
        if (this.getCollectPeriod() < 100L) {
            this.setCollectPeriod(100L);
        }
        this.close();
        this.stecaClient = this.createStecaClient();
        this.dataCollectorTimer = new Timer(String.format("dataCollectorTimer[%s]", this.getBeanName()));
        this.dataCollectorTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    StecaDataCollectorImpl.this.onDataCollectorTimerTaskRun();
                    int resetUsbAfterConsecutiveErrorCount = StecaDataCollectorImpl.this.getResetUsbAfterConsecutiveErrorCount();
                    if (resetUsbAfterConsecutiveErrorCount > 0 && StecaDataCollectorImpl.this.consecutiveErrorCount >= resetUsbAfterConsecutiveErrorCount) {
                        StecaDataCollectorImpl.this.consecutiveErrorCount = 0;
                        StecaDataCollectorImpl.this.requestResetUsbAndExit();
                    }
                }
                catch (Throwable x) {
                    logger.error(StecaDataCollectorImpl.this.getBeanInstanceName() + ".dataCollectorTimerTask.run: " + x, x);
                }
            }
        };
        this.dataCollectorTimer.scheduleAtFixedRate(this.dataCollectorTimerTask, 0L, this.getCollectPeriod());
    }

    private StecaClient createStecaClient() {
        StecaInterfaceType interfaceType = Objects.requireNonNull(this.getInterfaceType(), "interfaceType");
        String interfaceAddress = Objects.requireNonNull(this.getInterfaceAddress(), "interfaceAddress");
        switch (interfaceType) {
            case RXTX: {
                return new StecaClientRxTx(interfaceAddress);
            }
        }
        throw new UnsupportedOperationException("InterfaceType not yet supported: " + (Object)((Object)interfaceType));
    }

    @Override
    public void close() {
        EventQueue.invokeAndWait(() -> {
            StecaClient stecaClient = this.stecaClient;
            if (stecaClient != null) {
                this.stecaClient = null;
                try {
                    stecaClient.close();
                }
                catch (Exception e) {
                    logger.error("Closing StecaClient failed: " + e, (Throwable)e);
                }
            }
            if (this.dataCollectorTimerTask != null) {
                this.dataCollectorTimerTask.cancel();
                this.dataCollectorTimerTask = null;
            }
            if (this.dataCollectorTimer != null) {
                this.dataCollectorTimer.cancel();
                this.dataCollectorTimer = null;
            }
        });
    }

    protected void onDataCollectorTimerTaskRun() {
        DataCollectorEvent event;
        StecaClient stecaClient = Objects.requireNonNull(this.stecaClient, "stecaClient");
        try {
            InverterMode inverterMode = stecaClient.execute(new GetInverterMode());
            InverterStatus inverterStatus = stecaClient.execute(new GetInverterStatus());
            event = new DataCollectorEvent((PvDataCollector)this, inverterMode, inverterStatus);
            this.consecutiveErrorCount = 0;
        }
        catch (Exception x) {
            ++this.consecutiveErrorCount;
            logger.error(this.getBeanInstanceName() + ".onDataCollectorTimerTaskRun: consecutiveErrorCount=" + this.consecutiveErrorCount + ": " + x, (Throwable)x);
            event = new DataCollectorEvent((PvDataCollector)this, x, this.consecutiveErrorCount);
        }
        DataCollectorEvent _event = event;
        EventQueue.invokeLater(() -> this.fireDataCollectorEvent(_event));
    }

    protected void requestResetUsbAndExit() {
        logger.warn("{}.requestResetUsbAndExit: Entered.", (Object)this.getBeanInstanceName());
        try {
            File resetusbFile = new File(ConfigDir.getInstance().getFile(), "resetusb");
            resetusbFile.createNewFile();
            if (!resetusbFile.exists()) {
                throw new IOException("Could not create file: " + resetusbFile.getAbsolutePath());
            }
            System.exit(99);
        }
        catch (Exception x) {
            logger.error(this.getBeanInstanceName() + ".requestResetUsbAndExit: " + x, (Throwable)x);
        }
    }

    protected void fireDataCollectorEvent(DataCollectorEvent event) {
        Objects.requireNonNull(event, "event");
        for (DataCollectorListener listener : this.dataCollectorListeners) {
            if (event.getError() == null) {
                listener.onSuccess(event);
                continue;
            }
            listener.onError(event);
        }
    }

    @Override
    public void addDataCollectorListener(DataCollectorListener listener) {
        this.dataCollectorListeners.add(Objects.requireNonNull(listener, "listener"));
    }

    @Override
    public void removeDataCollectorListener(DataCollectorListener listener) {
        this.dataCollectorListeners.remove(listener);
    }

    @Override
    public long getCollectPeriod() {
        return this.collectPeriod;
    }

    @Override
    public void setCollectPeriod(long collectPeriod) {
        this.setPropertyValue(PvDataCollector.PropertyEnum.collectPeriod, collectPeriod);
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this.setPropertyValue(PvDataCollector.PropertyEnum.deviceName, deviceName);
    }

    @Override
    public StecaInterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    @Override
    public void setInterfaceType(StecaInterfaceType interfaceType) {
        this.setPropertyValue(PvDataCollector.PropertyEnum.interfaceType, (Object)interfaceType);
    }

    @Override
    public String getInterfaceAddress() {
        return this.interfaceAddress;
    }

    @Override
    public void setInterfaceAddress(String interfaceAddress) {
        this.setPropertyValue(PvDataCollector.PropertyEnum.interfaceAddress, interfaceAddress);
    }

    public int getResetUsbAfterConsecutiveErrorCount() {
        return this.resetUsbAfterConsecutiveErrorCount;
    }

    public void setResetUsbAfterConsecutiveErrorCount(int resetUsbAfterConsecutiveErrorCount) {
        this.resetUsbAfterConsecutiveErrorCount = resetUsbAfterConsecutiveErrorCount;
    }
}

