/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.lightcontroller;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.lightcontroller.LightControllerEventRequest;
import house.intelli.core.rpc.lightcontroller.LightControllerState;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.LightController;
import house.intelli.raspi.LightControllerImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class LightControllerEventNotifier {
    private static final Logger logger = LoggerFactory.getLogger(LightControllerEventNotifier.class);
    private ApplicationContext applicationContext;
    private List<LightControllerImpl> lightControllers = Collections.emptyList();
    private RpcContext rpcContext;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<String, Set<HostId>> beanId2listenerHostIds = new HashMap<String, Set<HostId>>();
    private LightControllerImpl ignoredLightController;
    private final PropertyChangeListener statePropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            AssertUtil.assertEventThread();
            LightControllerImpl lightController = (LightControllerImpl)event.getSource();
            if (LightControllerEventNotifier.this.ignoredLightController == lightController) {
                return;
            }
            final LightControllerState state = lightController.getState();
            final String beanId = lightController.getBeanName();
            if (beanId == null) {
                logger.error("statePropertyChangeListener.propertyChange: beanId not found for " + lightController);
                return;
            }
            Set listenerHostIds = (Set)LightControllerEventNotifier.this.beanId2listenerHostIds.get(beanId);
            logger.debug("statePropertyChangeListener.propertyChange: beanId={}, state={}, listenerHostIds={}", new Object[]{beanId, state, listenerHostIds});
            if (listenerHostIds == null) {
                return;
            }
            for (final HostId listenerHostId : listenerHostIds) {
                LightControllerEventNotifier.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LightControllerEventNotifier.this.invokeLightControllerEventRequest(listenerHostId, beanId, state);
                        }
                        catch (Exception x) {
                            logger.error("statePropertyChangeListener.propertyChange.run: " + x + ' ', (Throwable)x);
                        }
                    }
                });
            }
        }
    };

    protected void invokeLightControllerEventRequest(HostId listenerHostId, String beanId, LightControllerState state) throws RpcException {
        logger.debug("invokeKeyButtonSensorEventRequest: listenerHostId={}, beanId={}, state={}", new Object[]{listenerHostId, beanId, state});
        LightControllerEventRequest request = new LightControllerEventRequest();
        request.setServerHostId(listenerHostId);
        request.setChannelId(beanId);
        request.setLightControllerState(state);
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }

    public LightControllerEventNotifier() {
        logger.info("<init>");
    }

    public LightControllerImpl getIgnoredLightController() {
        AssertUtil.assertEventThread();
        return this.ignoredLightController;
    }

    public void setIgnoredLightController(LightControllerImpl ignoredLightController) {
        AssertUtil.assertEventThread();
        this.ignoredLightController = ignoredLightController;
    }

    public void addListener(String beanId, HostId listenerHostId) {
        Objects.requireNonNull(beanId, "beanId");
        Objects.requireNonNull(listenerHostId, "listenerHostId");
        AssertUtil.assertEventThread();
        Set<HostId> listenerHostIds = this.beanId2listenerHostIds.get(beanId);
        if (listenerHostIds == null) {
            listenerHostIds = new HashSet<HostId>(1);
            this.beanId2listenerHostIds.put(beanId, listenerHostIds);
        }
        listenerHostIds.add(listenerHostId);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public List<LightControllerImpl> getLightControllers() {
        return this.lightControllers;
    }

    @Autowired(required=false)
    public void setLightControllers(List<LightControllerImpl> lightControllers) {
        AssertUtil.assertEventThread();
        logger.debug("setLightControllers: lightControllers={}", lightControllers);
        List<LightControllerImpl> oldLightControllers = this.lightControllers;
        for (LightControllerImpl lightController : oldLightControllers) {
            lightController.removePropertyChangeListener(LightController.PropertyEnum.state, this.statePropertyChangeListener);
        }
        if (lightControllers == null) {
            this.lightControllers = Collections.emptyList();
        } else {
            for (LightControllerImpl lightController : lightControllers) {
                lightController.addPropertyChangeListener(LightController.PropertyEnum.state, this.statePropertyChangeListener);
            }
            this.lightControllers = Collections.unmodifiableList(new ArrayList<LightControllerImpl>(lightControllers));
        }
    }
}

