/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.lightcontroller;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.VoidResponse;
import house.intelli.core.rpc.lightcontroller.LightControllerEventRequest;
import house.intelli.core.rpc.lightcontroller.LightControllerState;
import house.intelli.raspi.LightControllerImpl;
import house.intelli.raspi.lightcontroller.LightControllerEventNotifier;
import java.util.LinkedList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class LightControllerEventService
extends AbstractRpcService<LightControllerEventRequest, VoidResponse> {
    private static final Logger logger = LoggerFactory.getLogger(LightControllerEventService.class);
    private ApplicationContext applicationContext;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public VoidResponse process(LightControllerEventRequest request) throws Exception {
        RemoteBeanRef remoteBeanRef = new RemoteBeanRef();
        remoteBeanRef.setHostId(Objects.requireNonNull(request.getClientHostId(), "request.clientHostId"));
        remoteBeanRef.setBeanId(Objects.requireNonNull(request.getChannelId(), "request.channelId"));
        LightControllerState state = Objects.requireNonNull(request.getLightControllerState(), "request.lightControllerState");
        logger.debug("process: remoteBeanRef={}, state={}", (Object)remoteBeanRef, (Object)state);
        LinkedList<LightControllerImpl> lightControllers = new LinkedList<LightControllerImpl>();
        for (LightControllerImpl lightController : this.applicationContext.getBeansOfType(LightControllerImpl.class).values()) {
            if (!lightController.getCollectedFederatedLightControllers().contains(remoteBeanRef)) continue;
            lightControllers.add(lightController);
        }
        if (lightControllers.isEmpty()) {
            return null;
        }
        LightControllerEventNotifier eventNotifier = (LightControllerEventNotifier)this.applicationContext.getBean(LightControllerEventNotifier.class);
        EventQueue.invokeLater(() -> {
            for (LightControllerImpl lightController : lightControllers) {
                eventNotifier.setIgnoredLightController(lightController);
                try {
                    lightController.setState(state);
                }
                finally {
                    eventNotifier.setIgnoredLightController(null);
                }
            }
        });
        return null;
    }
}

