/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.lightcontroller;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.VoidResponse;
import house.intelli.core.rpc.lightcontroller.LightControllerFederationPropagationRequest;
import house.intelli.raspi.LightControllerImpl;
import house.intelli.raspi.lightcontroller.LightControllerEventNotifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class LightControllerFederationPropagationService
extends AbstractRpcService<LightControllerFederationPropagationRequest, VoidResponse> {
    private static final Logger logger = LoggerFactory.getLogger(LightControllerFederationPropagationService.class);
    private ApplicationContext applicationContext;

    public LightControllerFederationPropagationService() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public VoidResponse process(LightControllerFederationPropagationRequest request) throws Exception {
        String channelId = Objects.requireNonNull(request.getChannelId(), "request.channelId");
        String sourceBeanId = Objects.requireNonNull(request.getSourceBeanId(), "request.sourceBeanId");
        logger.debug("process: clientHostId={}, sourceBeanId={}, channelId={}, federatedLightControllers={}", new Object[]{request.getClientHostId(), sourceBeanId, channelId, request.getFederatedLightControllers()});
        Object bean = this.applicationContext.getBean(channelId);
        if (bean == null) {
            throw new IllegalArgumentException("No bean found with beanId=channelId=" + channelId);
        }
        if (!(bean instanceof LightControllerImpl)) {
            throw new IllegalArgumentException("Bean with beanId=channelId=" + channelId + " is not an instance of LightControllerImpl, but: " + bean.getClass().getName());
        }
        LightControllerImpl lightController = (LightControllerImpl)bean;
        lightController.getCollectedFederatedLightControllers().addAll(request.getFederatedLightControllers());
        RemoteBeanRef sourceRemoteBeanRef = new RemoteBeanRef();
        sourceRemoteBeanRef.setHostId(request.getClientHostId());
        sourceRemoteBeanRef.setBeanId(sourceBeanId);
        boolean added = lightController.getCollectedFederatedLightControllers().add(sourceRemoteBeanRef);
        LightControllerEventNotifier eventNotifier = (LightControllerEventNotifier)this.applicationContext.getBean(LightControllerEventNotifier.class);
        EventQueue.invokeLater(() -> {
            eventNotifier.addListener(channelId, request.getClientHostId());
            if (added) {
                lightController.setState(request.getLightControllerState());
            }
        });
        return null;
    }
}

