/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.lightcontroller;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.lightcontroller.LightControllerFederationPropagationRequest;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.LightControllerImpl;
import house.intelli.raspi.lightcontroller.LightControllerEventNotifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class LightControllerFederationPropagator
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(LightControllerFederationPropagator.class);
    private static final long PROPAGATION_PERIOD = 60000L;
    private List<LightControllerImpl> lightControllers = Collections.emptyList();
    private final Timer timer = new Timer("LightControllerFederationPropagator.timer", true);
    private RpcContext rpcContext;
    private ApplicationContext applicationContext;
    private final TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                LightControllerFederationPropagator.this.propagate();
            }
            catch (Exception x) {
                logger.error("timerTask.run: " + x.toString(), (Throwable)x);
            }
        }
    };

    public LightControllerFederationPropagator() {
        logger.debug("<init>");
        this.timer.schedule(this.timerTask, 60000L, 60000L);
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public List<LightControllerImpl> getLightControllers() {
        return this.lightControllers;
    }

    @Autowired(required=false)
    public void setLightControllers(List<LightControllerImpl> lightControllers) {
        AssertUtil.assertEventThread();
        logger.debug("setLightControllers: lightControllers={}", lightControllers);
        this.lightControllers = lightControllers == null ? Collections.emptyList() : lightControllers;
    }

    protected void propagate() {
        for (LightControllerImpl lightController : this.getLightControllers()) {
            if (lightController.getCollectedFederatedLightControllers().isEmpty()) continue;
            try {
                this.propagate(lightController);
            }
            catch (Exception x) {
                logger.error("propagate: " + x.toString(), (Throwable)x);
            }
        }
    }

    protected void propagate(LightControllerImpl lightController) throws RpcException {
        Objects.requireNonNull(lightController, "lightController");
        for (RemoteBeanRef remoteBeanRef : lightController.getCollectedFederatedLightControllers()) {
            try {
                this.propagate(lightController, remoteBeanRef);
            }
            catch (Exception x) {
                logger.error("propagate: " + x.toString(), (Throwable)x);
                if (lightController.getFederatedLightControllers().contains(remoteBeanRef)) continue;
                lightController.getCollectedFederatedLightControllers().remove(remoteBeanRef);
            }
        }
    }

    protected void propagate(LightControllerImpl lightController, RemoteBeanRef remoteBeanRef) throws RpcException {
        Objects.requireNonNull(lightController, "lightController");
        Objects.requireNonNull(remoteBeanRef, "remoteBeanRef");
        logger.debug("propagate: {} => {}", (Object)lightController.getBeanName(), (Object)remoteBeanRef);
        LightControllerEventNotifier eventNotifier = (LightControllerEventNotifier)this.applicationContext.getBean(LightControllerEventNotifier.class);
        EventQueue.invokeLater(() -> eventNotifier.addListener(lightController.getBeanName(), remoteBeanRef.getHostId()));
        LightControllerFederationPropagationRequest request = new LightControllerFederationPropagationRequest();
        request.setServerHostId(remoteBeanRef.getHostId());
        request.setChannelId(remoteBeanRef.getBeanId());
        request.setSourceBeanId(Objects.requireNonNull(lightController.getBeanName(), "lightController.beanName"));
        request.setFederatedLightControllers(lightController.getCollectedFederatedLightControllers());
        request.setLightControllerState(lightController.getState());
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }
}

