/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv;

import house.intelli.core.config.ConfigDir;
import house.intelli.core.event.EventQueue;
import house.intelli.core.jaxb.IntelliHouseJaxbContext;
import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.pv.PvStatus;
import house.intelli.core.rpc.pv.PvStatusEventRequest;
import house.intelli.core.rpc.pv.PvStatusList;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.PvDataCollector;
import house.intelli.raspi.pv.DataCollectorEvent;
import house.intelli.raspi.pv.DataCollectorListener;
import house.intelli.raspi.pv.steca.InverterMode;
import house.intelli.raspi.pv.steca.InverterStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataCollectorBufferAndEventNotifier {
    private static final Logger logger = LoggerFactory.getLogger(DataCollectorBufferAndEventNotifier.class);
    private ApplicationContext applicationContext;
    private RpcContext rpcContext;
    private List<PvDataCollector> pvDataCollectors = Collections.emptyList();
    private PvStatusList pvStatusList = new PvStatusList();
    private Timer notifyTimer;
    private TimerTask notifyTimerTask;
    private long notifyPeriod = 30000L;
    private File bufferDir;
    private static final String DIR_DATE_FORMAT = "yyyy/MM/dd/HH";
    private static final String FILE_NAME_DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss.SSS";
    private static final String FILE_NAME_PREFIX = "pvStatusList.";
    private static final String FILE_NAME_SUFFIX = ".xml.gz";
    private static final String TMP_SUFFIX = ".tmp";
    private Thread shutdownHook;
    private final DataCollectorListener dataCollectorListener = new DataCollectorListener(){

        @Override
        public void onSuccess(DataCollectorEvent event) {
            AssertUtil.assertEventThread();
            Objects.requireNonNull(event, "event");
            PvStatus pvStatus = DataCollectorBufferAndEventNotifier.this.createPvStatus(event);
            DataCollectorBufferAndEventNotifier.this.pvStatusList.getPvStatuses().add(pvStatus);
        }

        @Override
        public void onError(DataCollectorEvent event) {
            AssertUtil.assertEventThread();
            Objects.requireNonNull(event, "event");
        }
    };
    private final Comparator<File> fileNameComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            String name1 = f1.getName();
            String name2 = f2.getName();
            return name1.compareTo(name2);
        }
    };

    public void init() {
        AssertUtil.assertEventThread();
        if (this.notifyTimerTask != null) {
            this.notifyTimerTask.cancel();
        }
        if (this.notifyTimer != null) {
            this.notifyTimer.cancel();
        }
        this.notifyTimer = new Timer(this.getClass().getSimpleName() + ".notifyTimer");
        this.notifyTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    DataCollectorBufferAndEventNotifier.this.notifyPvStatusList(true);
                }
                catch (Throwable x) {
                    logger.error("notifyTimerTask.run: " + x, x);
                }
            }
        };
        this.notifyTimer.schedule(this.notifyTimerTask, this.notifyPeriod, this.notifyPeriod);
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                @Override
                public void run() {
                    try {
                        DataCollectorBufferAndEventNotifier.this.onShutdown();
                    }
                    catch (Throwable x) {
                        logger.error("shutdownHook.run: " + x, x);
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    protected void onShutdown() throws Exception {
        logger.info("onShutdown: Invoking notifyPvStatusList...");
        this.notifyPvStatusList(false);
        logger.info("onShutdown: Invoked notifyPvStatusList.");
    }

    protected PvStatusList rollPvStatusList() {
        final PvStatusList[] result = new PvStatusList[1];
        EventQueue.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                result[0] = DataCollectorBufferAndEventNotifier.this.pvStatusList;
                DataCollectorBufferAndEventNotifier.this.pvStatusList = new PvStatusList();
            }
        });
        return Objects.requireNonNull(result[0], "result[0]");
    }

    protected void notifyPvStatusList(boolean sendOld) throws Exception {
        PvStatusList pvStatusList = this.rollPvStatusList();
        if (!pvStatusList.getPvStatuses().isEmpty()) {
            try {
                this.sendPvStatusListToServer(pvStatusList);
            }
            catch (Throwable x) {
                logger.error("notifyPvStatusList: " + x, x);
                this.storePvStatusListLocally(pvStatusList);
                return;
            }
        }
        if (sendOld) {
            this.sendOldPvStatusListsToServer();
        }
    }

    protected void sendPvStatusListToServer(PvStatusList pvStatusList) throws Exception {
        Objects.requireNonNull(pvStatusList, "pvStatusList");
        if (pvStatusList.getPvStatuses().isEmpty()) {
            logger.warn("sendPvStatusListToServer: pvStatusList.pvStatuses is empty! Skipping.");
            return;
        }
        PvStatusEventRequest request = new PvStatusEventRequest();
        request.setServerHostId(HostId.SERVER);
        request.setPvStatuses(pvStatusList.getPvStatuses());
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }

    protected void storePvStatusListLocally(PvStatusList pvStatusList) throws Exception {
        Objects.requireNonNull(pvStatusList, "pvStatusList");
        Date now = new Date();
        String dirStr = new SimpleDateFormat(DIR_DATE_FORMAT).format(now);
        File dir = new File(this.getBufferDir(), dirStr);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new IOException("Could not create directory: " + dir.getAbsolutePath());
        }
        String fileName = FILE_NAME_PREFIX + new SimpleDateFormat(FILE_NAME_DATE_FORMAT).format(now) + FILE_NAME_SUFFIX;
        File file = new File(dir, fileName);
        File tmpFile = new File(dir, fileName + TMP_SUFFIX);
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(tmpFile));){
            Marshaller marshaller = IntelliHouseJaxbContext.getJaxbContext().createMarshaller();
            marshaller.marshal((Object)pvStatusList, (OutputStream)out);
        }
        tmpFile.renameTo(file);
    }

    public File getBufferDir() {
        if (this.bufferDir == null) {
            this.bufferDir = new File(ConfigDir.getInstance().getFile(), "pvStatus");
            if (!this.bufferDir.isDirectory()) {
                this.bufferDir.mkdir();
            }
            if (!this.bufferDir.isDirectory()) {
                throw new RuntimeException(new IOException("Could not create directory: " + this.bufferDir.getAbsolutePath()));
            }
        }
        return this.bufferDir;
    }

    protected void sendOldPvStatusListsToServer() throws Exception {
        this.sendOldPvStatusListsToServer(System.currentTimeMillis(), this.getBufferDir());
    }

    protected boolean sendOldPvStatusListsToServer(long sendOldPvStatusListsToServerStartTimestamp, File dirOrFile) throws Exception {
        Objects.requireNonNull(dirOrFile);
        long duration = System.currentTimeMillis() - sendOldPvStatusListsToServerStartTimestamp;
        if (duration > this.notifyPeriod) {
            logger.info("sendOldPvStatusListsToServer: duration={} exceeds max={} => Aborting and postponing.", (Object)duration, (Object)this.notifyPeriod);
            return false;
        }
        if (dirOrFile.isDirectory()) {
            File[] children = dirOrFile.listFiles();
            if (children != null) {
                Arrays.sort(children, this.fileNameComparator);
                for (File child : children) {
                    if (!this.sendOldPvStatusListsToServer(sendOldPvStatusListsToServerStartTimestamp, child)) {
                        return false;
                    }
                    File[] children2 = child.listFiles();
                    if (children2 != null && children2.length != 0) continue;
                    child.delete();
                }
            }
        } else if (dirOrFile.isFile() && dirOrFile.getName().endsWith(FILE_NAME_SUFFIX)) {
            if (dirOrFile.length() == 0L) {
                logger.warn("sendOldPvStatusListsToServer: Skipping and deleting empty file: {}", (Object)dirOrFile.getAbsolutePath());
            } else {
                PvStatusList pvStatusList;
                try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(dirOrFile));){
                    Unmarshaller unmarshaller = IntelliHouseJaxbContext.getJaxbContext().createUnmarshaller();
                    pvStatusList = (PvStatusList)unmarshaller.unmarshal((InputStream)in);
                }
                this.sendPvStatusListToServer(pvStatusList);
            }
            dirOrFile.delete();
        }
        return true;
    }

    protected PvStatus createPvStatus(DataCollectorEvent event) {
        Objects.requireNonNull(event, "event");
        InverterMode inverterMode = Objects.requireNonNull(event.getInverterMode(), "event.inverterMode");
        InverterStatus inverterStatus = Objects.requireNonNull(event.getInverterStatus(), "event.inverterStatus");
        PvStatus pvStatus = new PvStatus();
        pvStatus.setDeviceName(event.getSource().getDeviceName());
        pvStatus.setMeasured(inverterStatus.getMeasured());
        pvStatus.setDeviceMode(new String(new char[]{inverterMode.getMode()}));
        pvStatus.setAcInVoltage(inverterStatus.getAcInVoltage());
        pvStatus.setAcInFrequency(inverterStatus.getAcInFrequency());
        pvStatus.setAcOutVoltage(inverterStatus.getAcOutVoltage());
        pvStatus.setAcOutFrequency(inverterStatus.getAcOutFrequency());
        pvStatus.setAcOutApparentPower(inverterStatus.getAcOutApparentPower());
        pvStatus.setAcOutActivePower(inverterStatus.getAcOutActivePower());
        pvStatus.setAcOutLoadPercentage(inverterStatus.getAcOutLoadPercentage());
        pvStatus.setInternalBusVoltage(inverterStatus.getInternalBusVoltage());
        pvStatus.setBatteryVoltageAtInverter(inverterStatus.getBatteryVoltageAtInverter());
        pvStatus.setBatteryChargeCurrent(inverterStatus.getBatteryChargeCurrent());
        pvStatus.setBatteryCapacityPercentage(inverterStatus.getBatteryCapacityPercentage());
        pvStatus.setHeatSinkTemperature(inverterStatus.getHeatSinkTemperature());
        pvStatus.setPvToBatteryCurrent(inverterStatus.getPvToBatteryCurrent());
        pvStatus.setPvVoltage(inverterStatus.getPvVoltage());
        pvStatus.setBatteryVoltageAtCharger(inverterStatus.getBatteryVoltageAtCharger());
        pvStatus.setBatteryDischargeCurrent(inverterStatus.getBatteryDischargeCurrent());
        pvStatus.setStatusBitmask(inverterStatus.getStatusBitmask());
        pvStatus.setEepromVersion(inverterStatus.getEepromVersion());
        pvStatus.setPvPower(inverterStatus.getPvPower());
        return pvStatus;
    }

    public long getNotifyPeriod() {
        return this.notifyPeriod;
    }

    public void setNotifyPeriod(long notifyPeriod) {
        this.notifyPeriod = notifyPeriod;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public List<PvDataCollector> getPvDataCollectors() {
        return this.pvDataCollectors;
    }

    @Autowired(required=false)
    public void setPvDataCollectors(List<PvDataCollector> pvDataCollectors) {
        AssertUtil.assertEventThread();
        logger.debug("setKeyButtonSensors: pvDataCollectors={}", pvDataCollectors);
        List<PvDataCollector> oldStecaDataCollectors = this.pvDataCollectors;
        for (PvDataCollector pvDataCollector : oldStecaDataCollectors) {
            pvDataCollector.removeDataCollectorListener(this.dataCollectorListener);
        }
        if (pvDataCollectors == null) {
            this.pvDataCollectors = Collections.emptyList();
        } else {
            for (PvDataCollector pvDataCollector : pvDataCollectors) {
                pvDataCollector.addDataCollectorListener(this.dataCollectorListener);
            }
            this.pvDataCollectors = Collections.unmodifiableList(new ArrayList<PvDataCollector>(pvDataCollectors));
        }
    }
}

