/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv;

import house.intelli.raspi.PvDataCollector;
import house.intelli.raspi.pv.steca.InverterMode;
import house.intelli.raspi.pv.steca.InverterStatus;
import java.util.EventObject;
import java.util.Objects;

public class DataCollectorEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final InverterMode inverterMode;
    private final InverterStatus inverterStatus;
    private final Throwable error;
    private final int consecutiveErrorCount;

    public DataCollectorEvent(PvDataCollector source, InverterMode inverterMode, InverterStatus inverterStatus) {
        super(source);
        this.inverterMode = Objects.requireNonNull(inverterMode, "inverterMode");
        this.inverterStatus = Objects.requireNonNull(inverterStatus, "inverterStatus");
        this.error = null;
        this.consecutiveErrorCount = 0;
    }

    public DataCollectorEvent(PvDataCollector source, Throwable error, int consecutiveErrorCount) {
        super(source);
        this.inverterMode = null;
        this.inverterStatus = null;
        this.error = Objects.requireNonNull(error, "error");
        this.consecutiveErrorCount = consecutiveErrorCount;
    }

    @Override
    public PvDataCollector getSource() {
        return (PvDataCollector)super.getSource();
    }

    public InverterMode getInverterMode() {
        return this.inverterMode;
    }

    public InverterStatus getInverterStatus() {
        return this.inverterStatus;
    }

    public Throwable getError() {
        return this.error;
    }

    public int getConsecutiveErrorCount() {
        return this.consecutiveErrorCount;
    }
}

