/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import java.util.Objects;

public class Crc {
    private static final int polynomial = 4129;
    private int crc;

    public Crc() {
        this.reset();
    }

    public void update(byte[] val) {
        Objects.requireNonNull(val, "val");
        this.update(val, 0, val.length);
    }

    public void update(byte[] val, int pos, int length) {
        Objects.requireNonNull(val, "val");
        for (int i = pos; i < pos + length; ++i) {
            this.update(val[i]);
        }
    }

    public void update(byte val) {
        for (int i = 0; i < 8; ++i) {
            boolean bit = (val >> 7 - i & 1) == 1;
            boolean c15 = (this.crc >> 15 & 1) == 1;
            this.crc <<= 1;
            if (!(c15 ^ bit)) continue;
            this.crc ^= 0x1021;
        }
    }

    public void reset() {
        this.crc = 0;
    }

    public int getCrc() {
        return this.crc;
    }

    public byte[] getCrcBytes() {
        int value = this.getCrc();
        return new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
    }
}

