/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import house.intelli.raspi.pv.steca.CrcException;
import house.intelli.raspi.pv.steca.InverterMode;
import house.intelli.raspi.pv.steca.MalformedResponseException;
import house.intelli.raspi.pv.steca.StecaRequest;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInverterMode
extends StecaRequest<InverterMode> {
    private static final Logger logger = LoggerFactory.getLogger(GetInverterMode.class);

    @Override
    public InverterMode execute() throws IOException {
        try {
            return this._execute();
        }
        catch (CrcException | MalformedResponseException x) {
            logger.warn("execute: Caught '{}' => Retrying.", (Object)x.toString());
            return this._execute();
        }
        catch (IOException x) {
            throw x;
        }
    }

    protected InverterMode _execute() throws IOException {
        this.writeRequest("QMOD");
        String response = this.readResponseAsString();
        if (response.length() != 1) {
            throw new IOException("Response has unexpected length (!= 1): " + response);
        }
        InverterMode result = new InverterMode();
        result.setMeasured(new Date());
        result.setMode(response.charAt(0));
        return result;
    }
}

