/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import house.intelli.raspi.pv.steca.CrcException;
import house.intelli.raspi.pv.steca.InverterStatus;
import house.intelli.raspi.pv.steca.MalformedResponseException;
import house.intelli.raspi.pv.steca.StecaRequest;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInverterStatus
extends StecaRequest<InverterStatus> {
    private static final Logger logger = LoggerFactory.getLogger(GetInverterStatus.class);

    @Override
    public InverterStatus execute() throws IOException {
        try {
            return this._execute();
        }
        catch (CrcException | MalformedResponseException x) {
            logger.warn("execute: Caught '{}' => Retrying.", (Object)x.toString());
            return this._execute();
        }
        catch (IOException x) {
            throw x;
        }
    }

    protected InverterStatus _execute() throws IOException {
        this.writeRequest("QPIGS");
        String response = this.readResponseAsString();
        String[] fields = response.split(" ");
        if (fields.length != 21) {
            throw new IOException("Malformed response: " + response);
        }
        InverterStatus result = new InverterStatus();
        result.setMeasured(new Date());
        int idx = -1;
        result.setAcInVoltage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcInFrequency(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcOutVoltage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcOutFrequency(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcOutApparentPower(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcOutActivePower(GetInverterStatus.parseFloat(fields[++idx]));
        result.setAcOutLoadPercentage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setInternalBusVoltage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setBatteryVoltageAtInverter(GetInverterStatus.parseFloat(fields[++idx]));
        result.setBatteryChargeCurrent(GetInverterStatus.parseFloat(fields[++idx]));
        result.setBatteryCapacityPercentage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setHeatSinkTemperature(GetInverterStatus.parseFloat(fields[++idx]));
        result.setPvToBatteryCurrent(GetInverterStatus.parseInt(fields[++idx]));
        result.setPvVoltage(GetInverterStatus.parseFloat(fields[++idx]));
        result.setBatteryVoltageAtCharger(GetInverterStatus.parseFloat(fields[++idx]));
        result.setBatteryDischargeCurrent(GetInverterStatus.parseFloat(fields[++idx]));
        result.setStatusBitmask(GetInverterStatus.parseIntBinary(fields[++idx]));
        ++idx;
        result.setEepromVersion(GetInverterStatus.parseInt(fields[++idx]));
        result.setPvPower(GetInverterStatus.parseFloat(fields[++idx]));
        int statusBits2 = GetInverterStatus.parseIntBinary(fields[++idx]);
        result.setStatusBitmask(result.getStatusBitmask() | (statusBits2 <<= 8));
        return result;
    }
}

