/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import house.intelli.raspi.pv.steca.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StecaClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(StecaClient.class);

    public abstract void open() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract boolean isOpen();

    protected abstract InputStream getInputStream();

    protected abstract OutputStream getOutputStream();

    public <R> R execute(Request<R> request) throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
        request.setStecaClient(this);
        try {
            R r;
            this.preExecute(request);
            try {
                R result = request.execute();
                this.postExecute(request, null);
                r = result;
            }
            catch (Exception x) {
                try {
                    this.postExecute(request, x);
                }
                catch (Exception pex) {
                    logger.error("postExecute failed: " + pex, (Throwable)pex);
                }
                throw x;
            }
            return r;
        }
        finally {
            request.setStecaClient(null);
        }
    }

    protected void preExecute(Request<?> request) throws IOException {
    }

    protected void postExecute(Request<?> request, Throwable error) throws IOException {
    }
}

