/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import house.intelli.raspi.pv.steca.Request;
import house.intelli.raspi.pv.steca.StecaClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StecaClientRxTx
extends StecaClient {
    private static final Logger logger = LoggerFactory.getLogger(StecaClientRxTx.class);
    private static final int timeoutMillis = 5000;
    private static final int baudrate = 2400;
    private static final int dataBits = 8;
    private static final int stopBits = 1;
    private static final int parity = 0;
    private final String portName;
    private CommPortIdentifier commPortIdentifier;
    private CommPort commPort;
    private SerialPort serialPort;
    private volatile InputStream inputStream;
    private volatile OutputStream outputStream;

    public StecaClientRxTx(String portName) {
        this.portName = Objects.requireNonNull(portName, "portName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() throws IOException {
        if (this.isOpen()) {
            return;
        }
        logger.info("open: Opening port '{}'...", (Object)this.portName);
        boolean failed = true;
        try {
            try {
                this.commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)this.portName);
            }
            catch (NoSuchPortException e) {
                logger.error("open: Port '{}' not found! Listing existing ports:", (Object)this.portName);
                try {
                    Enumeration commPorts = CommPortIdentifier.getPortIdentifiers();
                    if (!commPorts.hasMoreElements()) {
                        logger.error("open: THERE ARE NO PORTS!!!");
                    }
                    while (commPorts.hasMoreElements()) {
                        CommPortIdentifier cpi = (CommPortIdentifier)commPorts.nextElement();
                        logger.error("open:   * {}", (Object)cpi.getName());
                    }
                }
                catch (Exception x) {
                    logger.error("open: Listing ports failed: " + x, (Throwable)x);
                }
                throw new IOException(String.format("Port '%s' could not be opened: %s", this.portName, e.getMessage()), e);
            }
            try {
                this.commPort = this.commPortIdentifier.open(this.getClass().getName(), 5000);
            }
            catch (PortInUseException e) {
                throw new IOException(String.format("Port '%s' is in use!", this.portName), e);
            }
            if (this.commPort == null) {
                throw new IOException(String.format("Port '%s' could not be opened for an unknown reason!", this.portName));
            }
            if (!(this.commPort instanceof SerialPort)) {
                throw new IOException(String.format("Port '%s' is not a serial port! Its type is %s instead of %s!", this.portName, this.commPort.getClass().getName(), SerialPort.class.getName()));
            }
            this.serialPort = (SerialPort)this.commPort;
            try {
                this.serialPort.setSerialPortParams(2400, 8, 1, 0);
            }
            catch (UnsupportedCommOperationException e) {
                throw new IOException(String.format("Port '%s' could not be configured: %s", this.portName, e.getMessage()), e);
            }
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
            logger.info("open: Opened port '{}'.", (Object)this.portName);
            failed = false;
        }
        finally {
            if (failed) {
                this.close();
            }
        }
    }

    @Override
    public InputStream getInputStream() {
        InputStream result = this.inputStream;
        if (result == null) {
            throw this.newPortNotOpenException();
        }
        return result;
    }

    @Override
    public OutputStream getOutputStream() {
        OutputStream result = this.outputStream;
        if (result == null) {
            throw this.newPortNotOpenException();
        }
        return result;
    }

    @Override
    protected void preExecute(Request<?> request) throws IOException {
        int bytesAvailable;
        InputStream in = this.getInputStream();
        while ((bytesAvailable = in.available()) > 0) {
            in.skip(bytesAvailable);
        }
    }

    @Override
    public boolean isOpen() {
        return this.outputStream != null;
    }

    protected RuntimeException newPortNotOpenException() {
        return new IllegalStateException(String.format("Port '%s' is not open!", this.portName));
    }

    @Override
    public synchronized void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (Exception x) {
                logger.warn("Closing outputStream failed: " + x, (Throwable)x);
            }
            this.outputStream = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception x) {
                logger.warn("Closing inputStream failed: " + x, (Throwable)x);
            }
            this.inputStream = null;
        }
        this.serialPort = null;
        if (this.commPort != null) {
            logger.info("close: Closing port '{}'...", (Object)this.portName);
            try {
                this.commPort.close();
            }
            catch (Exception x) {
                logger.warn("Closing commPort failed: " + x, (Throwable)x);
            }
            this.commPort = null;
            logger.info("close: Closed port '{}'.", (Object)this.portName);
        }
        if (this.commPortIdentifier != null) {
            this.commPortIdentifier = null;
        }
    }
}

