/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.pv.steca;

import house.intelli.raspi.pv.steca.AbstractRequest;
import house.intelli.raspi.pv.steca.Crc;
import house.intelli.raspi.pv.steca.CrcException;
import house.intelli.raspi.pv.steca.MalformedResponseException;
import house.intelli.raspi.pv.steca.TimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public abstract class StecaRequest<R>
extends AbstractRequest<R> {
    private static final long readTimeoutMillis = 3000L;
    private static final Charset CHARSET = StandardCharsets.US_ASCII;

    protected static int parseIntBinary(String string) {
        return Integer.parseInt(string, 2);
    }

    protected static int parseInt(String string) {
        return Integer.parseInt(string);
    }

    protected static float parseFloat(String string) {
        return Float.parseFloat(string);
    }

    protected void writeRequest(String command) throws IOException {
        Objects.requireNonNull(command, "command");
        byte[] commandBytes = command.getBytes(CHARSET);
        Crc crc = new Crc();
        crc.update(commandBytes, 0, commandBytes.length);
        byte[] crcBytes = crc.getCrcBytes();
        OutputStream out = this.getStecaClientOrFail().getOutputStream();
        out.write(commandBytes);
        out.write(crcBytes);
        out.write(13);
    }

    protected String readResponseAsString() throws IOException {
        byte[] responseBytes = this.readResponse();
        String response = new String(responseBytes, CHARSET);
        return response;
    }

    protected byte[] readResponse() throws IOException {
        byte[] rawResponse = this.readRawResponse();
        if (rawResponse.length < 4) {
            throw new MalformedResponseException("Response too short: " + Arrays.toString(rawResponse));
        }
        if (rawResponse[0] != 40) {
            throw new MalformedResponseException("Response did not start with '(': " + Arrays.toString(rawResponse));
        }
        byte[] response = new byte[rawResponse.length - 1 - 2 - 1];
        System.arraycopy(rawResponse, 1, response, 0, response.length);
        Crc crc = new Crc();
        crc.update((byte)40);
        crc.update(response);
        byte[] crcBytes = crc.getCrcBytes();
        int rawResponseCrcIndex = rawResponse.length - 1;
        if (crcBytes[1] != rawResponse[--rawResponseCrcIndex]) {
            throw new CrcException(String.format("CRC error! calculated=%s found=%s", StecaRequest.toHex(crcBytes[0]) + StecaRequest.toHex(crcBytes[1]), StecaRequest.toHex(rawResponse[rawResponseCrcIndex - 1]) + StecaRequest.toHex(rawResponse[rawResponseCrcIndex])));
        }
        if (crcBytes[0] != rawResponse[--rawResponseCrcIndex]) {
            throw new CrcException(String.format("CRC error! calculated=%s found=%s", StecaRequest.toHex(crcBytes[0]) + StecaRequest.toHex(crcBytes[1]), StecaRequest.toHex(rawResponse[rawResponseCrcIndex]) + StecaRequest.toHex(rawResponse[rawResponseCrcIndex + 1])));
        }
        return response;
    }

    protected static String toHex(byte val) {
        String hex = Integer.toHexString(val & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    protected byte[] readRawResponse() throws IOException {
        InputStream in = this.getStecaClientOrFail().getInputStream();
        byte[] buf = new byte[1024];
        ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
        long startTimeStamp = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTimeStamp > 3000L) {
                throw new TimeoutException("Timeout! Read so far: " + Arrays.toString(responseBuffer.toByteArray()));
            }
            int available = in.available();
            if (available > 0) {
                int length = in.read(buf);
                responseBuffer.write(buf, 0, length);
                if (!this.containsCr(buf, length)) continue;
                return responseBuffer.toByteArray();
            }
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected boolean containsCr(byte[] buf, int length) {
        for (int i = 0; i < buf.length; ++i) {
            if (i >= length) {
                return false;
            }
            if (buf[i] != 13) continue;
            return true;
        }
        return false;
    }
}

