/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.dimmer;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.dimmer.DimmerActorEventRequest;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.DimmerActor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DimmerActorEventNotifier {
    private static final Logger logger = LoggerFactory.getLogger(DimmerActorEventNotifier.class);
    private ApplicationContext applicationContext;
    private List<DimmerActor> dimmerActors = Collections.emptyList();
    private RpcContext rpcContext;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final IdentityHashMap<DimmerActor, String> dimmerActor2BeanId = new IdentityHashMap();
    private final PropertyChangeListener dimmerValuePropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            AssertUtil.assertEventThread();
            if (DimmerActorEventNotifier.this.dimmerActor2BeanId.isEmpty()) {
                Map beanId2DimmerActor = DimmerActorEventNotifier.this.applicationContext.getBeansOfType(DimmerActor.class);
                for (Map.Entry me : beanId2DimmerActor.entrySet()) {
                    DimmerActorEventNotifier.this.dimmerActor2BeanId.put(me.getValue(), me.getKey());
                }
            }
            DimmerActor dimmerActor = (DimmerActor)event.getSource();
            final int dimmerValue = dimmerActor.getDimmerValue();
            final String beanId = (String)DimmerActorEventNotifier.this.dimmerActor2BeanId.get(dimmerActor);
            if (beanId == null) {
                logger.error("dimmerValuePropertyChangeListener.propertyChange: beanId not found for " + dimmerActor);
                return;
            }
            logger.debug("dimmerValuePropertyChangeListener.propertyChange: beanId={}, dimmerValue={}", (Object)beanId, (Object)dimmerValue);
            DimmerActorEventNotifier.this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        DimmerActorEventNotifier.this.invokeDimmerActorEventRequest(beanId, dimmerValue);
                    }
                    catch (Exception x) {
                        logger.error("dimmerValuePropertyChangeListener.propertyChange.run: " + x + ' ', (Throwable)x);
                    }
                }
            });
        }
    };

    protected void invokeDimmerActorEventRequest(String beanId, int dimmerValue) throws RpcException {
        logger.debug("invokeDimmerActorEventRequest: beanId={}, dimmerValue={}", (Object)beanId, (Object)dimmerValue);
        DimmerActorEventRequest request = new DimmerActorEventRequest();
        request.setServerHostId(HostId.SERVER);
        request.setChannelId(beanId);
        request.setDimmerValue(dimmerValue);
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }

    public DimmerActorEventNotifier() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public List<DimmerActor> getDimmerActors() {
        return this.dimmerActors;
    }

    @Autowired(required=false)
    public void setDimmerActors(List<DimmerActor> dimmerActors) {
        AssertUtil.assertEventThread();
        logger.debug("setDimmerActors: dimmerActors={}", dimmerActors);
        List<DimmerActor> oldDimmerActors = this.dimmerActors;
        for (DimmerActor dimmerActor : oldDimmerActors) {
            dimmerActor.removePropertyChangeListener(DimmerActor.PropertyEnum.dimmerValue, this.dimmerValuePropertyChangeListener);
        }
        if (dimmerActors == null) {
            this.dimmerActors = Collections.emptyList();
        } else {
            for (DimmerActor dimmerActor : dimmerActors) {
                dimmerActor.addPropertyChangeListener(DimmerActor.PropertyEnum.dimmerValue, this.dimmerValuePropertyChangeListener);
            }
            this.dimmerActors = Collections.unmodifiableList(new ArrayList<DimmerActor>(dimmerActors));
        }
    }
}

