/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.dimmer;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.dimmer.DimmerActorWriteRequest;
import house.intelli.core.rpc.dimmer.DimmerActorWriteResponse;
import house.intelli.raspi.DimmerActor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DimmerActorWriteRpcService
extends AbstractRpcService<DimmerActorWriteRequest, DimmerActorWriteResponse> {
    private static final Logger logger = LoggerFactory.getLogger(DimmerActorWriteRpcService.class);
    private ApplicationContext applicationContext;

    public DimmerActorWriteRpcService() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public DimmerActorWriteResponse process(DimmerActorWriteRequest request) throws Exception {
        String channelId = Objects.requireNonNull(request.getChannelId(), "request.channelId");
        Object bean = this.applicationContext.getBean(channelId);
        if (bean == null) {
            throw new IllegalArgumentException("No bean found with beanId=channelId=" + channelId);
        }
        if (!(bean instanceof DimmerActor)) {
            throw new IllegalArgumentException("Bean with beanId=channelId=" + channelId + " is not an instance of DimmerActor, but: " + bean.getClass().getName());
        }
        DimmerActor dimmerActor = (DimmerActor)bean;
        DimmerActorWriteResponse[] response = new DimmerActorWriteResponse[1];
        EventQueue.invokeAndWait(() -> {
            dimmerActor.setDimmerValue(request.getDimmerValue());
            response[0] = new DimmerActorWriteResponse();
            response[0].setDimmerValue(dimmerActor.getDimmerValue());
        });
        return response[0];
    }
}

