/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.keybutton;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.keybutton.KeyButtonSensorEventRequest;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.KeyButtonSensor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class KeyButtonSensorEventNotifier {
    private static final Logger logger = LoggerFactory.getLogger(KeyButtonSensorEventNotifier.class);
    private ApplicationContext applicationContext;
    private List<KeyButtonSensor> keyButtonSensors = Collections.emptyList();
    private RpcContext rpcContext;
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Map<String, Set<HostId>> beanId2listenerHostIds = new HashMap<String, Set<HostId>>();
    private final PropertyChangeListener downPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            AssertUtil.assertEventThread();
            KeyButtonSensor keyButtonSensor = (KeyButtonSensor)event.getSource();
            final boolean down = keyButtonSensor.isDown();
            final String beanId = keyButtonSensor.getBeanName();
            if (beanId == null) {
                logger.error("downPropertyChangeListener.propertyChange: beanId not found for " + keyButtonSensor);
                return;
            }
            Set listenerHostIds = (Set)KeyButtonSensorEventNotifier.this.beanId2listenerHostIds.get(beanId);
            logger.debug("downPropertyChangeListener.propertyChange: beanId={}, down={}, listenerHostIds={}", new Object[]{beanId, down, listenerHostIds});
            if (listenerHostIds == null) {
                return;
            }
            for (final HostId listenerHostId : listenerHostIds) {
                KeyButtonSensorEventNotifier.this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            KeyButtonSensorEventNotifier.this.invokeKeyButtonSensorEventRequest(listenerHostId, beanId, down);
                        }
                        catch (Exception x) {
                            logger.error("downPropertyChangeListener.propertyChange.run: " + x + ' ', (Throwable)x);
                        }
                    }
                });
            }
        }
    };

    protected void invokeKeyButtonSensorEventRequest(HostId listenerHostId, String beanId, boolean down) throws RpcException {
        logger.debug("invokeKeyButtonSensorEventRequest: listenerHostId={}, beanId={}, down={}", new Object[]{listenerHostId, beanId, down});
        KeyButtonSensorEventRequest request = new KeyButtonSensorEventRequest();
        request.setServerHostId(listenerHostId);
        request.setChannelId(beanId);
        request.setDown(down);
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }

    public KeyButtonSensorEventNotifier() {
        logger.info("<init>");
    }

    public void addListener(String beanId, HostId listenerHostId) {
        Objects.requireNonNull(beanId, "beanId");
        Objects.requireNonNull(listenerHostId, "listenerHostId");
        AssertUtil.assertEventThread();
        Set<HostId> listenerHostIds = this.beanId2listenerHostIds.get(beanId);
        if (listenerHostIds == null) {
            listenerHostIds = new HashSet<HostId>(1);
            this.beanId2listenerHostIds.put(beanId, listenerHostIds);
        }
        listenerHostIds.add(listenerHostId);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public List<KeyButtonSensor> getKeyButtonSensors() {
        return this.keyButtonSensors;
    }

    @Autowired(required=false)
    public void setKeyButtonSensors(List<KeyButtonSensor> keyButtonSensors) {
        AssertUtil.assertEventThread();
        logger.debug("setKeyButtonSensors: keyButtonSensors={}", keyButtonSensors);
        List<KeyButtonSensor> oldKeyButtonSensors = this.keyButtonSensors;
        for (KeyButtonSensor keyButtonSensor : oldKeyButtonSensors) {
            keyButtonSensor.removePropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.downPropertyChangeListener);
        }
        if (keyButtonSensors == null) {
            this.keyButtonSensors = Collections.emptyList();
        } else {
            for (KeyButtonSensor keyButtonSensor : keyButtonSensors) {
                keyButtonSensor.addPropertyChangeListener(KeyButtonSensor.PropertyEnum.down, this.downPropertyChangeListener);
            }
            this.keyButtonSensors = Collections.unmodifiableList(new ArrayList<KeyButtonSensor>(keyButtonSensors));
        }
    }
}

