/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.keybutton;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.VoidResponse;
import house.intelli.core.rpc.keybutton.KeyButtonSensorEventRequest;
import house.intelli.raspi.KeyButtonSensorRemote;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class KeyButtonSensorEventService
extends AbstractRpcService<KeyButtonSensorEventRequest, VoidResponse> {
    private static final Logger logger = LoggerFactory.getLogger(KeyButtonSensorEventService.class);
    private ApplicationContext applicationContext;
    private volatile Map<RemoteBeanRef, List<KeyButtonSensorRemote>> remoteBeanRef2KeyButtonSensorRemote;

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public VoidResponse process(KeyButtonSensorEventRequest request) throws Exception {
        RemoteBeanRef remoteBeanRef = new RemoteBeanRef();
        remoteBeanRef.setHostId(Objects.requireNonNull(request.getClientHostId(), "request.clientHostId"));
        remoteBeanRef.setBeanId(Objects.requireNonNull(request.getChannelId(), "request.channelId"));
        logger.debug("process: remoteBeanRef={}", (Object)remoteBeanRef);
        List<KeyButtonSensorRemote> list = this.getRemoteBeanRef2KeyButtonSensorRemote().get(remoteBeanRef);
        if (list == null || list.isEmpty()) {
            return null;
        }
        EventQueue.invokeLater(() -> {
            for (KeyButtonSensorRemote keyButtonSensorRemote : list) {
                keyButtonSensorRemote.setDown(request.isDown());
            }
        });
        return null;
    }

    protected Map<RemoteBeanRef, List<KeyButtonSensorRemote>> getRemoteBeanRef2KeyButtonSensorRemote() {
        Map<RemoteBeanRef, List<KeyButtonSensorRemote>> map = this.remoteBeanRef2KeyButtonSensorRemote;
        if (map == null) {
            map = new HashMap<RemoteBeanRef, List<KeyButtonSensorRemote>>();
            Map beansOfType = this.applicationContext.getBeansOfType(KeyButtonSensorRemote.class);
            for (KeyButtonSensorRemote keyButtonSensorRemote : beansOfType.values()) {
                List<KeyButtonSensorRemote> list = map.get(keyButtonSensorRemote.getRemoteBeanRef());
                if (list == null) {
                    list = new ArrayList<KeyButtonSensorRemote>(1);
                    map.put(keyButtonSensorRemote.getRemoteBeanRef(), list);
                }
                list.add(keyButtonSensorRemote);
            }
            this.remoteBeanRef2KeyButtonSensorRemote = map;
        }
        return map;
    }
}

