/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.keybutton;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.VoidResponse;
import house.intelli.core.rpc.keybutton.KeyButtonSensorRemotePropagationRequest;
import house.intelli.raspi.KeyButtonSensor;
import house.intelli.raspi.rpc.keybutton.KeyButtonSensorEventNotifier;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class KeyButtonSensorRemotePropagationService
extends AbstractRpcService<KeyButtonSensorRemotePropagationRequest, VoidResponse> {
    private static final Logger logger = LoggerFactory.getLogger(KeyButtonSensorRemotePropagationService.class);
    private ApplicationContext applicationContext;

    public KeyButtonSensorRemotePropagationService() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public VoidResponse process(KeyButtonSensorRemotePropagationRequest request) throws Exception {
        String channelId = Objects.requireNonNull(request.getChannelId(), "request.channelId");
        logger.debug("process: clientHostId={}, channelId={}", (Object)request.getClientHostId(), (Object)channelId);
        Object bean = this.applicationContext.getBean(channelId);
        if (bean == null) {
            throw new IllegalArgumentException("No bean found with beanId=channelId=" + channelId);
        }
        if (!(bean instanceof KeyButtonSensor)) {
            throw new IllegalArgumentException("Bean with beanId=channelId=" + channelId + " is not an instance of KeyButtonSensor, but: " + bean.getClass().getName());
        }
        KeyButtonSensorEventNotifier eventNotifier = (KeyButtonSensorEventNotifier)this.applicationContext.getBean(KeyButtonSensorEventNotifier.class);
        EventQueue.invokeLater(() -> eventNotifier.addListener(channelId, request.getClientHostId()));
        return null;
    }
}

