/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.keybutton;

import house.intelli.core.rpc.RemoteBeanRef;
import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.RpcException;
import house.intelli.core.rpc.keybutton.KeyButtonSensorRemotePropagationRequest;
import house.intelli.core.util.AssertUtil;
import house.intelli.raspi.KeyButtonSensorRemote;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeyButtonSensorRemotePropagator {
    private static final Logger logger = LoggerFactory.getLogger(KeyButtonSensorRemotePropagator.class);
    private static final long PROPAGATION_PERIOD = 60000L;
    private List<KeyButtonSensorRemote> keyButtonSensorRemotes = Collections.emptyList();
    private final Timer timer = new Timer("KeyButtonSensorRemotePropagator.timer", true);
    private RpcContext rpcContext;
    private final TimerTask timerTask = new TimerTask(){

        @Override
        public void run() {
            try {
                KeyButtonSensorRemotePropagator.this.propagate();
            }
            catch (Exception x) {
                logger.error("timerTask.run: " + x.toString(), (Throwable)x);
            }
        }
    };

    public KeyButtonSensorRemotePropagator() {
        logger.debug("<init>");
        this.timer.schedule(this.timerTask, 60000L, 60000L);
    }

    public RpcContext getRpcContext() {
        return this.rpcContext;
    }

    @Autowired
    public void setRpcContext(RpcContext rpcContext) {
        this.rpcContext = rpcContext;
    }

    public List<KeyButtonSensorRemote> getKeyButtonSensorRemotes() {
        return this.keyButtonSensorRemotes;
    }

    @Autowired(required=false)
    public void setKeyButtonSensorRemotes(List<KeyButtonSensorRemote> keyButtonSensorRemotes) {
        AssertUtil.assertEventThread();
        logger.debug("setKeyButtonSensors: keyButtonSensorRemotes={}", keyButtonSensorRemotes);
        this.keyButtonSensorRemotes = keyButtonSensorRemotes == null ? Collections.emptyList() : keyButtonSensorRemotes;
    }

    protected void propagate() {
        for (KeyButtonSensorRemote keyButtonSensorRemote : this.getKeyButtonSensorRemotes()) {
            try {
                this.propagate(keyButtonSensorRemote);
            }
            catch (Exception x) {
                logger.error("propagate: " + x.toString(), (Throwable)x);
            }
        }
    }

    protected void propagate(KeyButtonSensorRemote keyButtonSensorRemote) throws RpcException {
        Objects.requireNonNull(keyButtonSensorRemote, "keyButtonSensorRemote");
        RemoteBeanRef remoteBeanRef = keyButtonSensorRemote.getRemoteBeanRef();
        Objects.requireNonNull(remoteBeanRef, "keyButtonSensorRemote.remoteBeanRef");
        logger.debug("propagate: {}", (Object)remoteBeanRef);
        KeyButtonSensorRemotePropagationRequest request = new KeyButtonSensorRemotePropagationRequest();
        request.setServerHostId(remoteBeanRef.getHostId());
        request.setChannelId(remoteBeanRef.getBeanId());
        try (RpcClient rpcClient = this.rpcContext.createRpcClient();){
            rpcClient.invoke((Request)request);
        }
    }
}

