/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.relay;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.relay.RelayActorReadRequest;
import house.intelli.core.rpc.relay.RelayActorReadResponse;
import house.intelli.raspi.RelayActor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RelayActorReadRpcService
extends AbstractRpcService<RelayActorReadRequest, RelayActorReadResponse> {
    private static final Logger logger = LoggerFactory.getLogger(RelayActorReadRpcService.class);
    private ApplicationContext applicationContext;

    public RelayActorReadRpcService() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public RelayActorReadResponse process(RelayActorReadRequest request) throws Exception {
        String channelId = Objects.requireNonNull(request.getChannelId(), "request.channelId");
        Object bean = this.applicationContext.getBean(channelId);
        if (bean == null) {
            throw new IllegalArgumentException("No bean found with beanId=channelId=" + channelId);
        }
        if (!(bean instanceof RelayActor)) {
            throw new IllegalArgumentException("Bean with beanId=channelId=" + channelId + " is not an instance of RelayActor, but: " + bean.getClass().getName());
        }
        RelayActor relayActor = (RelayActor)bean;
        RelayActorReadResponse[] response = new RelayActorReadResponse[1];
        EventQueue.invokeAndWait(() -> {
            response[0] = new RelayActorReadResponse();
            response[0].setEnergized(relayActor.isEnergized());
        });
        return response[0];
    }
}

