/*
 * Decompiled with CFR 0.152.
 */
package house.intelli.raspi.rpc.relay;

import house.intelli.core.event.EventQueue;
import house.intelli.core.rpc.AbstractRpcService;
import house.intelli.core.rpc.relay.RelayActorWriteRequest;
import house.intelli.core.rpc.relay.RelayActorWriteResponse;
import house.intelli.raspi.RelayActor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class RelayActorWriteRpcService
extends AbstractRpcService<RelayActorWriteRequest, RelayActorWriteResponse> {
    private static final Logger logger = LoggerFactory.getLogger(RelayActorWriteRpcService.class);
    private ApplicationContext applicationContext;

    public RelayActorWriteRpcService() {
        logger.info("<init>");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        logger.info("setApplicationContext: {}", (Object)applicationContext);
        this.applicationContext = applicationContext;
    }

    public RelayActorWriteResponse process(RelayActorWriteRequest request) throws Exception {
        String channelId = Objects.requireNonNull(request.getChannelId(), "request.channelId");
        Object bean = this.applicationContext.getBean(channelId);
        if (bean == null) {
            throw new IllegalArgumentException("No bean found with beanId=channelId=" + channelId);
        }
        if (!(bean instanceof RelayActor)) {
            throw new IllegalArgumentException("Bean with beanId=channelId=" + channelId + " is not an instance of RelayActor, but: " + bean.getClass().getName());
        }
        RelayActor relayActor = (RelayActor)bean;
        RelayActorWriteResponse[] response = new RelayActorWriteResponse[1];
        EventQueue.invokeAndWait(() -> {
            relayActor.setEnergized(request.isEnergized());
            response[0] = new RelayActorWriteResponse();
            response[0].setEnergized(relayActor.isEnergized());
        });
        return response[0];
    }
}

