/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.handler;

import house.intelli.core.rpc.Request;
import house.intelli.core.rpc.RpcClient;
import house.intelli.core.rpc.RpcContext;
import house.intelli.core.rpc.dimmer.DimmerActorReadRequest;
import house.intelli.core.rpc.dimmer.DimmerActorReadResponse;
import house.intelli.core.rpc.dimmer.DimmerActorWriteRequest;
import house.intelli.core.rpc.dimmer.DimmerActorWriteResponse;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.openhab.binding.intellihouse.handler.IntelliHouseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntelliHouseDimmerHandler
extends IntelliHouseHandler {
    private Logger logger = LoggerFactory.getLogger(IntelliHouseDimmerHandler.class);

    public IntelliHouseDimmerHandler(Thing thing) {
        super(thing);
    }

    @Override
    protected String getAcceptedItemType() {
        return "Dimmer";
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.info("handleCommand: channelUID={}, command={}", (Object)channelUID, (Object)command);
        RpcContext rpcContext = this.getRpcContextOrFail();
        String channelId = channelUID.getIdWithoutGroup();
        if (command instanceof RefreshType) {
            try {
                this.readAndUpdateState(channelUID);
            }
            catch (Exception e) {
                this.logger.error("DimmerActorReadRequest for channelUID=" + channelUID + " failed: " + e, (Throwable)e);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.toString());
            }
        } else if (command instanceof PercentType) {
            PercentType percent = (PercentType)command;
            DimmerActorWriteRequest request = new DimmerActorWriteRequest();
            request.setServerHostId(this.getServerHostId());
            request.setChannelId(channelId);
            request.setDimmerValue(percent.intValue());
            DimmerActorWriteResponse response = null;
            try {
                Throwable throwable = null;
                Object var9_12 = null;
                try (RpcClient rpcClient = rpcContext.createRpcClient();){
                    response = (DimmerActorWriteResponse)rpcClient.invoke((Request)request);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.logger.error("DimmerActorWriteRequest for channelUID=" + channelUID + " failed: " + e, (Throwable)e);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.toString());
            }
            if (response != null) {
                PercentType responsePercent = new PercentType(response.getDimmerValue());
                this.updateStatus(ThingStatus.ONLINE);
                this.updateState(channelUID, (State)responsePercent);
            }
        }
    }

    @Override
    protected void initializeChannel(ChannelUID channelUID) throws Exception {
        super.initializeChannel(channelUID);
        this.readAndUpdateState(channelUID);
    }

    private void readAndUpdateState(ChannelUID channelUID) throws Exception {
        String channelId = channelUID.getIdWithoutGroup();
        RpcContext rpcContext = this.getRpcContextOrFail();
        DimmerActorReadRequest request = new DimmerActorReadRequest();
        request.setServerHostId(this.getServerHostId());
        request.setChannelId(channelId);
        DimmerActorReadResponse response = null;
        Throwable throwable = null;
        Object var7_8 = null;
        try (RpcClient rpcClient = rpcContext.createRpcClient();){
            response = (DimmerActorReadResponse)rpcClient.invoke((Request)request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (response != null) {
            PercentType responsePercent = new PercentType(response.getDimmerValue());
            this.updateStatus(ThingStatus.ONLINE);
            this.updateState(channelUID, (State)responsePercent);
        }
    }
}

