/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.handler;

import house.intelli.core.rpc.HostId;
import house.intelli.core.rpc.RpcContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.thing.binding.builder.ThingBuilder;
import org.eclipse.smarthome.core.thing.link.ItemChannelLink;
import org.eclipse.smarthome.core.thing.link.ItemChannelLinkRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IntelliHouseHandler
extends BaseThingHandler {
    private Logger logger = LoggerFactory.getLogger(IntelliHouseHandler.class);
    protected BundleContext bundleContext;
    protected ItemChannelLinkRegistry linkRegistry;
    private HostId serverHostId;
    private final Set<ChannelUID> initializedChannelUIDs = Collections.synchronizedSet(new HashSet());
    private ServiceTracker linkRegistryServiceTracker;

    public IntelliHouseHandler(Thing thing) {
        super(thing);
    }

    public void setBundleContext(final BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        super.setBundleContext(bundleContext);
        this.linkRegistryServiceTracker = new ServiceTracker(this.bundleContext, ItemChannelLinkRegistry.class.getName(), null){

            public Object addingService(@Nullable ServiceReference reference) {
                IntelliHouseHandler.this.linkRegistry = (ItemChannelLinkRegistry)bundleContext.getService(reference);
                return IntelliHouseHandler.this.linkRegistry;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(@Nullable ServiceReference reference, @Nullable Object service) {
                IntelliHouseHandler intelliHouseHandler = IntelliHouseHandler.this;
                synchronized (intelliHouseHandler) {
                    IntelliHouseHandler.this.linkRegistry = null;
                }
            }
        };
        this.linkRegistryServiceTracker.open();
    }

    public void unsetBundleContext(@NonNull BundleContext bundleContext) {
        this.linkRegistryServiceTracker.close();
        super.unsetBundleContext(bundleContext);
        this.bundleContext = null;
    }

    public void initialize() {
        this.logger.info("initialize: thingUid={}: Beginning initialization.", (Object)this.getThing().getUID());
        try {
            this.serverHostId = new HostId((String)this.getThing().getConfiguration().get("hostId"));
        }
        catch (Exception x) {
            this.logger.warn("initialize.run: thingUid=" + this.getThing().getUID() + ": hostId missing/illegal: " + x, (Throwable)x);
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "hostId missing/illegal!");
            return;
        }
        this.getRpcContextOrFail();
        final ThingUID thingUID = this.getThing().getUID();
        this.updateStatus(ThingStatus.UNKNOWN);
        this.linkRegistry.addRegistryChangeListener((RegistryChangeListener)new RegistryChangeListener<ItemChannelLink>(){

            public void added(ItemChannelLink link) {
                ChannelUID channelUID = Objects.requireNonNull(link, "link").getLinkedUID();
                Objects.requireNonNull(channelUID, "link.uid");
                if (thingUID.equals((Object)channelUID.getThingUID())) {
                    IntelliHouseHandler.this.registerChannelIfNeeded(channelUID);
                    IntelliHouseHandler.this.startInitializeChannelThreadIfNeeded(channelUID);
                }
            }

            public void updated(ItemChannelLink oldLink, ItemChannelLink link) {
            }

            public void removed(ItemChannelLink link) {
            }
        });
        for (ChannelUID channelUID : this.getChannelUIDs()) {
            this.registerChannelIfNeeded(channelUID);
            this.startInitializeChannelThreadIfNeeded(channelUID);
        }
    }

    protected void startInitializeChannelThreadIfNeeded(final ChannelUID channelUID) {
        Objects.requireNonNull(channelUID, "channelUID");
        if (!this.initializedChannelUIDs.add(channelUID)) {
            return;
        }
        new Thread("InitializeChannelThread[" + channelUID + ']'){

            @Override
            public void run() {
                try {
                    IntelliHouseHandler.this.initializeChannel(channelUID);
                    if (ThingStatus.UNKNOWN.equals((Object)IntelliHouseHandler.this.thing.getStatus())) {
                        IntelliHouseHandler.this.updateStatus(ThingStatus.ONLINE);
                    }
                }
                catch (Exception x) {
                    IntelliHouseHandler.this.logger.error("initialize.run: " + x, (Throwable)x);
                    IntelliHouseHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %1$tZ: %2$s", new Date(), x));
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerChannelIfNeeded(ChannelUID channelUID) {
        Thing thing;
        Objects.requireNonNull(channelUID, "channelUID");
        Thing thing2 = thing = this.getThing();
        synchronized (thing2) {
            ArrayList<Channel> channels = new ArrayList<Channel>(thing.getChannels());
            for (Channel channel : channels) {
                if (!channelUID.equals((Object)channel.getUID())) continue;
                this.logger.info("registerChannelIfNeeded: thingUid={}: Channel already existing (skip): {}", (Object)thing.getUID(), (Object)channelUID);
                return;
            }
            this.logger.info("registerChannelIfNeeded: thingUid={}: Registering channel: {}", (Object)thing.getUID(), (Object)channelUID);
            ThingBuilder thingBuilder = this.editThing();
            ChannelBuilder channelBuilder = ChannelBuilder.create((ChannelUID)channelUID, (String)this.getAcceptedItemType());
            channels.add(channelBuilder.build());
            thingBuilder.withChannels(channels);
            this.updateThing(thingBuilder.build());
            this.logger.info("registerChannelIfNeeded: thingUid={}: Channels: {}", (Object)thing.getUID(), (Object)this.toChannelUidStringList(thing.getChannels()));
        }
    }

    protected String toChannelUidStringList(List<Channel> channels) {
        StringBuilder sb = new StringBuilder();
        for (Channel channel : channels) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(channel.getUID());
        }
        return sb.toString();
    }

    protected void initializeChannel(ChannelUID channelUID) throws Exception {
    }

    protected abstract String getAcceptedItemType();

    protected <S> S getServiceOrFail(Class<S> serviceClass) {
        Objects.requireNonNull(serviceClass, "serviceClass");
        ServiceReference serviceReference = this.bundleContext.getServiceReference(serviceClass);
        if (serviceReference == null) {
            throw new IllegalStateException("No ServiceReference found for: " + serviceClass.getName());
        }
        Object service = this.bundleContext.getService(serviceReference);
        if (service == null) {
            throw new IllegalStateException("ServiceReference did not point to existing service: " + serviceReference);
        }
        return (S)service;
    }

    protected Collection<ChannelUID> getChannelUIDs() {
        this.logger.info("getChannelUids: thing.channels={}", (Object)this.thing.getChannels());
        ThingUID thingUid = this.thing.getUID();
        LinkedHashSet<ChannelUID> channelUids = new LinkedHashSet<ChannelUID>();
        for (ItemChannelLink itemChannelLink : this.linkRegistry.getAll()) {
            ChannelUID channelUid = itemChannelLink.getLinkedUID();
            if (!thingUid.equals((Object)channelUid.getThingUID())) continue;
            channelUids.add(channelUid);
        }
        this.logger.info("getChannelUids: channelUids={}", channelUids);
        return channelUids;
    }

    protected HostId getServerHostId() {
        return this.serverHostId;
    }

    protected RpcContext getRpcContextOrFail() {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(RpcContext.class);
        if (serviceReference == null) {
            throw new IllegalStateException("No ServiceReference found for: " + RpcContext.class.getName());
        }
        RpcContext rpcContext = (RpcContext)this.bundleContext.getService(serviceReference);
        if (rpcContext == null) {
            throw new IllegalStateException("ServiceReference did not point to existing service: " + serviceReference);
        }
        return rpcContext;
    }
}

