/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.openhab.binding.intellihouse.IntelliHouseBindingConstants;
import org.openhab.binding.intellihouse.handler.IntelliHouseDimmerHandler;
import org.openhab.binding.intellihouse.handler.IntelliHouseSwitchHandler;

public class IntelliHouseHandlerFactory
extends BaseThingHandlerFactory {
    private static final Set<ThingTypeUID> SUPPORTED_THING_TYPES_UIDS = Collections.unmodifiableSet(new HashSet<ThingTypeUID>(Arrays.asList(IntelliHouseBindingConstants.THING_TYPE_DIMMER, IntelliHouseBindingConstants.THING_TYPE_SWITCH)));

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return SUPPORTED_THING_TYPES_UIDS.contains(thingTypeUID);
    }

    protected @Nullable ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (thingTypeUID.equals((Object)IntelliHouseBindingConstants.THING_TYPE_DIMMER)) {
            return new IntelliHouseDimmerHandler(thing);
        }
        if (thingTypeUID.equals((Object)IntelliHouseBindingConstants.THING_TYPE_SWITCH)) {
            return new IntelliHouseSwitchHandler(thing);
        }
        return null;
    }
}

