/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.jdo;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombiClassLoader
extends ClassLoader {
    private final Logger logger = LoggerFactory.getLogger(CombiClassLoader.class);
    private final List<ClassLoader> delegates;

    public CombiClassLoader(List<ClassLoader> delegates) {
        this.delegates = new ArrayList<ClassLoader>((Collection)Objects.requireNonNull(delegates, "delegates"));
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader delegate : this.delegates) {
            try {
                Class<?> clazz = delegate.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException x) {
                this.logger.trace(x.toString(), (Throwable)x);
            }
            catch (NoClassDefFoundError x) {
                this.logger.trace(x.toString(), (Throwable)x);
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader delegate : this.delegates) {
            URL resource = delegate.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedList<URL> result = new LinkedList<URL>();
        for (ClassLoader delegate : this.delegates) {
            Enumeration<URL> resources = delegate.getResources(name);
            while (resources.hasMoreElements()) {
                result.add(resources.nextElement());
            }
        }
        return new IteratorEnumeration<URL>(result.iterator());
    }

    @Override
    protected URL findResource(String name) {
        throw new UnsupportedOperationException("Not implemented! Should never be called!");
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        throw new UnsupportedOperationException("Not implemented! Should never be called!");
    }

    @Override
    protected String findLibrary(String libname) {
        throw new UnsupportedOperationException("Not implemented! Should never be called!");
    }

    protected static class IteratorEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<E> iterator;

        public IteratorEnumeration(Iterator<E> iterator) {
            this.iterator = Objects.requireNonNull(iterator, "iterator");
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }
}

