/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.binding.intellihouse.jdo;

import house.intelli.core.util.ReflectionUtil;
import house.intelli.jdo.IntelliHouseTransaction;
import house.intelli.jdo.IntelliHouseTransactionImpl;
import house.intelli.jdo.model.PvStatusEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Transaction;
import org.openhab.binding.intellihouse.IntelliHouseActivator;
import org.openhab.binding.intellihouse.jdo.CombiClassLoader;
import org.openhab.binding.intellihouse.jdo.JdoPersistenceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdoPersistenceServiceImpl
implements JdoPersistenceService {
    private final Logger logger = LoggerFactory.getLogger(JdoPersistenceServiceImpl.class);
    private BundleContext bundleContext;
    private final AtomicInteger singleThreadAssertCounter = new AtomicInteger();
    private volatile PersistenceManagerFactory persistenceManagerFactory;
    private volatile Throwable startError;
    private volatile Map<String, Object> configProps = Collections.emptyMap();
    public static final String CONFIG_KEY_ENABLED = "enabled";
    private final List<Bundle> requiredBundles = new LinkedList<Bundle>();

    public JdoPersistenceServiceImpl() {
        this.logger.debug("<init>");
    }

    protected void activate(Map<String, Object> configProps) {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            try {
                this.startError = null;
                this.logger.debug("activate: Starting JdoPersistenceService. configProps={}", configProps);
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("singleThreadAssertCounterValue != 0");
                }
                this.bundleContext = IntelliHouseActivator.getInstance().getBundleContext();
                this.configProps = Collections.unmodifiableMap(new HashMap<String, Object>(configProps));
                this.start();
            }
            catch (Throwable x) {
                this.startError = x;
                this.logger.error("activate: " + x, x);
                this.singleThreadAssertCounter.decrementAndGet();
            }
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    protected void modified(Map<String, Object> configProps) {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            try {
                this.startError = null;
                this.logger.debug("modified: New configuration JdoPersistenceService. configProps={}", configProps);
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("singleThreadAssertCounterValue != 0");
                }
                this.stop();
                this.configProps = Collections.unmodifiableMap(new HashMap<String, Object>(configProps));
                this.start();
            }
            catch (Throwable x) {
                this.startError = x;
                this.logger.error("modified: " + x, x);
                this.singleThreadAssertCounter.decrementAndGet();
            }
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    protected void deactivate() {
        int singleThreadAssertCounterValue = this.singleThreadAssertCounter.getAndIncrement();
        try {
            try {
                this.startError = null;
                this.logger.debug("deactivate: Stopping JdoPersistenceService.");
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("singleThreadAssertCounterValue != 0");
                }
                this.stop();
            }
            catch (Exception e) {
                this.logger.error("deactivate: " + e, (Throwable)e);
                this.singleThreadAssertCounter.decrementAndGet();
            }
        }
        finally {
            this.singleThreadAssertCounter.decrementAndGet();
        }
    }

    protected void start() throws Exception {
        if (!this.isEnabled()) {
            this.logger.warn("JdoPersistenceService is not enabled! To enable it, you must set 'org.openhab.binding.intellihouse.jdo.JdoPersistenceService:enabled=true' in the file 'JdoPersistenceService.cfg'!");
            return;
        }
        this.startRequiredBundlesIfNeeded();
        CombiClassLoader cl = this.createCombiClassLoader();
        this.initJdbcDriver(cl);
        HashMap<String, Object> persistenceProperties = new HashMap<String, Object>(this.configProps);
        persistenceProperties.put("javax.jdo.PersistenceManagerFactoryClass", "org.datanucleus.api.jdo.JDOPersistenceManagerFactory");
        persistenceProperties.put("datanucleus.plugin.pluginRegistryClassName", "org.datanucleus.plugin.OSGiPluginRegistry");
        this.persistenceManagerFactory = JDOHelper.getPersistenceManagerFactory(persistenceProperties, (ClassLoader)cl);
        try (PersistenceManager pm = this.persistenceManagerFactory.getPersistenceManager();){
            Transaction tx = pm.currentTransaction();
            tx.begin();
            try {
                this.initEntityClasses(pm);
                tx.commit();
            }
            finally {
                if (tx.isActive()) {
                    tx.rollback();
                }
            }
        }
        this.logger.info("start: JdoPersistenceService started successfully.");
    }

    protected void initEntityClasses(PersistenceManager pm) {
        pm.getExtent(PvStatusEntity.class);
    }

    protected void initJdbcDriver(ClassLoader cl) throws Exception {
        Object jdbcDriverNameObj = this.configProps.get("javax.jdo.option.ConnectionDriverName");
        if (jdbcDriverNameObj == null) {
            this.logger.warn("initJdbcDriver: Property 'javax.jdo.option.ConnectionDriverName' is not set!");
        } else {
            String jdbcDriverName = jdbcDriverNameObj.toString().trim();
            if (jdbcDriverName.isEmpty()) {
                this.logger.warn("initJdbcDriver: Property 'javax.jdo.option.ConnectionDriverName' is empty!");
            } else {
                Class<?> jdbcDriverClass;
                this.logger.info("initJdbcDriver: Loading JDBC driver {}...", (Object)jdbcDriverName);
                try {
                    jdbcDriverClass = cl.loadClass(jdbcDriverName);
                }
                catch (Exception x) {
                    jdbcDriverClass = null;
                    this.logger.error("start: Loading JDBC driver '" + jdbcDriverName + "' failed: " + x, (Throwable)x);
                }
                this.logger.info("initJdbcDriver: Loaded JDBC driver {} successfully.", (Object)jdbcDriverName);
                if (jdbcDriverClass != null) {
                    this.logger.info("initJdbcDriver: Trying to (re)register JDBC driver.");
                    try {
                        ReflectionUtil.invokeStatic(jdbcDriverClass, (String)"deregister", (Object[])new Object[0]);
                    }
                    catch (Throwable x) {
                        this.logger.debug("initJdbcDriver: deregister '" + jdbcDriverName + "' failed: " + x, x);
                    }
                    try {
                        ReflectionUtil.invokeStatic(jdbcDriverClass, (String)"register", (Object[])new Object[0]);
                        this.logger.info("initJdbcDriver: registered {} successfully.", (Object)jdbcDriverName);
                    }
                    catch (Throwable x) {
                        this.logger.warn("initJdbcDriver: register '" + jdbcDriverName + "' failed: " + x, x);
                    }
                }
            }
        }
    }

    protected void startRequiredBundlesIfNeeded() throws Exception {
        this.requiredBundles.clear();
        this.requiredBundles.add(this.startBundleIfNeeded("org.postgresql.jdbc41"));
        this.requiredBundles.add(this.startBundleIfNeeded("javax.jdo"));
        this.requiredBundles.add(this.startBundleIfNeeded("org.datanucleus"));
        this.requiredBundles.add(this.startBundleIfNeeded("org.datanucleus.api.jdo"));
        this.requiredBundles.add(this.startBundleIfNeeded("org.datanucleus.store.rdbms"));
    }

    protected CombiClassLoader createCombiClassLoader() {
        LinkedList<ClassLoader> bundleClassLoaders = new LinkedList<ClassLoader>();
        for (Bundle bundle : this.requiredBundles) {
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
            bundleClassLoaders.add(bundleClassLoader);
        }
        bundleClassLoaders.add(JdoPersistenceServiceImpl.class.getClassLoader());
        return new CombiClassLoader(bundleClassLoaders);
    }

    protected Bundle startBundleIfNeeded(String symbolicName) throws Exception {
        Objects.requireNonNull(symbolicName, "symbolicName");
        Bundle bundle = this.getBundleBySymbolicName(symbolicName);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle not found: " + symbolicName);
        }
        int bundleState = bundle.getState();
        if (32 == bundleState) {
            this.logger.info("Bundle '{}' is already active.", (Object)symbolicName);
            return bundle;
        }
        this.logger.info("Bundle '{}' is not active, but state='{}'. Starting it now...", (Object)symbolicName, (Object)this.getBundleStateString(bundleState));
        try {
            bundle.start();
        }
        catch (Exception e) {
            this.logger.info("Bundle '" + symbolicName + "' could not be started: " + e, (Throwable)e);
            throw e;
        }
        this.logger.info("Bundle '{}' was started. Current state='{}'.", (Object)symbolicName, (Object)this.getBundleStateString(bundle.getState()));
        return bundle;
    }

    protected Bundle getBundleBySymbolicName(String symbolicName) {
        Objects.requireNonNull(symbolicName, "symbolicName");
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (symbolicName.equals(bundle.getSymbolicName())) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    protected String getBundleStateString(int bundleState) {
        switch (bundleState) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return Integer.toString(bundleState);
    }

    protected void stop() throws Exception {
        PersistenceManagerFactory pmf = this.persistenceManagerFactory;
        if (pmf != null) {
            pmf.close();
        }
        this.persistenceManagerFactory = null;
    }

    @Override
    public boolean isEnabled() {
        Object configValue = this.configProps.get(CONFIG_KEY_ENABLED);
        if (configValue == null) {
            this.logger.warn("Configuration does not contain key '{}'! JdoPersistenceService is disabled!", (Object)CONFIG_KEY_ENABLED);
            return false;
        }
        String configStr = String.valueOf(configValue).trim();
        if (Boolean.TRUE.toString().equals(configStr)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(configStr)) {
            return false;
        }
        this.logger.warn("Configuration key '{}' is assigned illegal value '{}'! JdoPersistenceService is disabled!", (Object)CONFIG_KEY_ENABLED);
        return false;
    }

    @Override
    public PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.startError != null) {
            throw new IllegalStateException("Starting up PersistenceManagerFactory failed (before): " + this.startError);
        }
        if (this.bundleContext == null) {
            throw new IllegalStateException("activate was not yet called!");
        }
        PersistenceManagerFactory pmf = this.persistenceManagerFactory;
        if (pmf == null) {
            if (this.isEnabled()) {
                int singleThreadAssertCounterValue = this.singleThreadAssertCounter.get();
                if (singleThreadAssertCounterValue != 0) {
                    throw new IllegalStateException("JdoPersistenceService is not active (currently starting or stopping)!");
                }
                throw new IllegalStateException("JdoPersistenceService is not active (but why?!??)!");
            }
            throw new IllegalStateException("JdoPersistenceService is not enabled! You must set 'org.openhab.binding.intellihouse.jdo.JdoPersistenceService:enabled=true' in the file 'JdoPersistenceService.cfg'!");
        }
        return pmf;
    }

    @Override
    public IntelliHouseTransaction beginTransaction() {
        return new IntelliHouseTransactionImpl(this.getPersistenceManagerFactory());
    }
}

